var VentaActivity = function () {
    "use strict";

    var dom = App.getContainerMain();
    var domNumero, domLoteria, domMonto, domTableJugadas;

    var isJugadaUpdate = false;
    var isSPaleDefined = false;
    var isSPale = false;
    let config_jugada_pale_op = 0;
    let typePaledDefined = 0;
    let isCash3Defined = false;
    let isCash3Straight = false;
    let isPlay4Defined = false;
    let isPlay4Straight = false;
    let isOpenModalElegirLoteria = false;
    let hasLoteriaFocus = false;

    let isNumeroFijo = false;
    let isLoteriaFijo = false;
    let isMontoFijo = false;

    var type_venta;
    var ticket_uuid;

    var initHtml = function () { console.log("VentaActivity.initHtml()");
        dom.empty();

        var html = '' +
            '<section class="box-typical box-vender">' +
            '   <header class="box-typical-header">' +
            '       <div class="tbl-row">' +
            '           <div class="tbl-cell tbl-cell-title"><h3>Vender</h3></div>' +
            '           <div class="tbl-cell tbl-cell-action-bordered" id="venta-icon-print" style="display: none"><button type="button" class="action-btn"><i class="fa fa-print" aria-hidden="true"></i></button></div>' +
            '           <div class="tbl-cell tbl-cell-action-bordered" id="venta-icon-sms" style="display: none"><button type="button" class="action-btn"><i class="fa fa-envelope-o" aria-hidden="true"></i></button></div>' +
            '           <div class="tbl-cell tbl-cell-action-bordered" id="venta-icon-none" style="display: none"><button type="button" class="action-btn"><i class="fa fa-external-link" aria-hidden="true"></i></button></div>' +
            '       </div>' +
            '   </header>' +
            '   <div class="box-typical-body">' +
            '       <div class="table-responsive">' +
            '           <table id="table_jugadas" class="table table-bordered table-hover table-sm">' +
            '               <thead>' +
            '                   <tr>' +
            '                       <th width="5%">#</th>' +
            '                       <th width="10%">PR</th>' +
            '                       <th>Jugada</th>' +
            '                       <th width="20%">Loteria</th>' +
            '                       <th width="15%">Monto</th>' +
            '                   </tr>' +
            '               </thead>' +
            '               <tbody></tbody>' +
            '               <tfoot>' +
            '                   <tr><th width="100%" colspan="5" style="text-align: right" id="jugadas_total_monto">$000</th></tr>' +
            '               </tfoot>' +
            '           </table>';

        dom.append(html);

        html = '' +
            '           <table class="table table-hover box-vender-bottom">' +
            '               <thead>' +
            '                   <tr>' +
            '                       <th><input type="text" class="form-control" id="add_jugada_numero" placeholder="Jugada" va></th>' +
            '                       <th><input type="text" class="form-control" id="add_jugada_loteria" placeholder="Loteria"></th>' +
            '                       <th><div class="input-group"><div class="input-group-addon">$</div><input type="text" class="form-control" id="add_jugada_monto" placeholder="Monto">' +
            '                   </th>' +
            '                   </tr>' +
            '               </thead>' +
            '           </table>' +
            '       </div>' +
            '   </div>' +
            '</section>';

        dom.append(html);


        html = '<section class="box-typical loterias-logos">';
        let list = [];
        let loterias = Loterias.getList();
        loterias.forEach(function (loteria) {
            console.log(loteria);
            if (loteria.getTipo()) {
                if (loteria.isOpen()) {
                    list.push('<img src="img/loterias/logo_'+loteria.getTipo()+'.jpg" class="activo">');
                }
                else {
                    list.push('<img src="img/loterias/logo_'+loteria.getTipo()+'.jpg">');
                }
            }
        });

        html += list.join('<hr>');

            /*'<img src="img/loterias/logo_nyd.jpg" class="activo"><hr>' +
            '<img src="img/loterias/logo_real.jpg" class="fijo activo"><hr>' +
            '<img src="img/loterias/logo_ganamas.jpg"><hr>' +
            '<img src="img/loterias/logo_loteka.jpg"><hr>' +
            '<img src="img/loterias/logo_nyn.jpg"><hr>' +
            '<img src="img/loterias/logo_leidsa.jpg" class="inactivo"><hr>' +
            '<img src="img/loterias/logo_nacional.jpg">' +*/

        html += '</section>';
        dom.append(html);
    }
    
    var initListeners = function () { console.log("VentaActivity.initListeners()");
        domTableJugadas = $('#table_jugadas tbody');
        domLoteria = $('#add_jugada_loteria');
        domNumero = $('#add_jugada_numero');
        domMonto = $('#add_jugada_monto');

        $('#table_jugadas').on('click', 'tbody tr', function () {
            var trID = $(this).attr('id');
            var position = parseInt(ut.only_number(trID)) - 1;
            var jugada = Jugadas.get(position);
            console.log("tr click: " + position);
            console.log(jugada);

            var html = '<ul class="nav nav-tabs nav-stacked list-dialog" id="dialog-ticketNewJugadaAction">';
            html += '<li id="_op_venta_edit"><a href="#link">'+ _t('edit') +'</a></li>';
            html += '<li id="_op_venta_delete"><a href="#link">'+ _t('delete') +'</a></li>';
            html += '</ul>';

            $.confirm({
                backgroundDismiss: true,
                title: '',
                content: html,
                buttons: {
                    buttonA: {isHidden: true},
                    buttonB: {isHidden: true}
                },
                onContentReady: function () {
                    var modal = this;

                    $('ul#dialog-ticketNewJugadaAction li').keynavigator({
                        activeClass: 'alert-info',
                        keys: {
                            enter: function($el) {
                                var op_selected = $el.attr('id');
                                modal.close();

                                if (op_selected == '_op_venta_edit') {
                                    $('#add_jugada_numero').val(jugada.getNumero());
                                    $('#add_jugada_loteria').val(jugada.getLoteria());
                                    $('#add_jugada_monto').val(jugada.getMonto());
                                }
                                else if (op_selected == '_op_venta_delete') {
                                    Jugadas.remove(position);
                                }
                            }
                        }
                    });

                    $('ul#dialog-copiarP2 li:eq(0)').click();
                }
            });
        });

        domNumero.keypress(function (e) {
            if(e.which == 13) {
                var numero = $(this).val();
                if (!VentaUtils.validarNumeric(numero)) {
                    ui.dialogError(_t('invalid_jugada'));
                    return;
                }

                if (e.shiftKey) {
                    domNumero.prop('readonly', true);
                    isNumeroFijo = true;
                }

                setFocusLoteria();
            }
        });

        domNumero.click(function (e) {
            isNumeroFijo = false;
            domNumero.prop('readonly', false);
            setFocusNumero(true);
        });

        domLoteria.keypress(function (e) {
            if (e.which == 13) { console.log("enter")
                var value = $(this).val();

                if (VentaUtils.hasElegirLoteria()) {
                    if (!VentaUtils.validarLoteriaByAbreviado(value)) {
                        ui.dialogErrorSimple(_t('ticket_invalid_loteria'));
                    }
                }
                else {
                    if (!VentaUtils.validarLoteriaByCode(value)) {
                        ui.dialogErrorSimple(_t('ticket_invalid_loteria'));
                        return;
                    }
                }

                setFocusMonto();
            }
        });

        domLoteria.click(function (e) {
            setFocusLoteria(true);
        });

        domMonto.keypress(function (e) {
            if (e.which == 13) {
                var value = $(this).val();
                if (!VentaUtils.validarMonto(value)) {
                    ui.dialogErrorSimple(_t('ticket_invalid_valor'));
                    return;
                }

                addJugadaEval();
            }
        });
    }

    var addJugadaEval = function() {
        var numero = getValNumero();
        var loteria = getValorLoteria();
        var monto = getValorMonto(); console.log("monto:"+monto);
        var jugstr;

        let loteriaModel;

        // validamos loteria
        if (validator.isNumeric(loteria)) {
            // si es codigo
            if (!VentaUtils.validarLoteriaByCode(loteria)) {
                ui.dialogErrorSimple(_t('ticket_invalid_loteria'));
                setFocusLoteria();
                return;
            }

            if (!VentaUtils.validarLoteriaCierreByCode(loteria)) {
                setFocusLoteria();
                return;
            }

            loteriaModel = Loterias.getFirstFromCodigos(loteria);
        }
        else {
            if (!VentaUtils.validarLoteriaByAbreviado(loteria)) {
                ui.dialogErrorSimple(_t('ticket_invalid_loteria'));
                return;
            }

            if (!VentaUtils.validarLoteriaCierreByAbreviado(loteria)) {
                return;
            }

            loteriaModel = Loterias.getFirstFromAbreviados(loteria);
        }

        // validamos numero
        if (!VentaUtils.validarNumero(numero, loteria)) {
            setFocusNumero();
            ui.dialogError(_t('invalid_jugada'));
            return;
        }

        // validamos valor
        if (!VentaUtils.validarMonto(monto)) {
            ui.dialogErrorSimple(_t('ticket_invalid_valor'));
            setFocusMonto();
            return;
        }

        // checamos tipo de jugada (jugstr)
        if (loteriaModel.isCash3()) {
            if (!isCash3Defined) {
                modal.ventaDefineCash3();
                return;
            }

            if (isCash3Straight) {
                jugstr = Jugadas.CASH3_STRAIGHT;
            }
            else {
                jugstr = Jugadas.CASH3_BOX;
            }
        }
        else if (loteriaModel.isPlay4()) {
            if (!isPlay4Defined) {
                modal.ventaDefinePlay4()
                return;
            }

            if (isPlay4Straight) {
                jugstr = Jugadas.PLAY4_STRAIGHT;
            }
            else {
                jugstr = Jugadas.PLAY4_BOX;
            }
        }
        // checamos si es quiniela
        else if (VentaUtils.isQuiniela(numero)) {
            jugstr = Jugadas.QUINIELA;
        }
        // checamos si es pale o super pale
        else if (Jugadas.isPale(numero)) {

            // si hay dos loterias, preguntamos si es pale o spale
            if (loteria.length == 2) {

                // si no se ha definido si es pale o spale, hay que definirlo
                if (!isSPaleDefined) {
                    modal.ventaDefinePale();
                    return;
                }

                if (isSPale) {
                    jugstr = Jugadas.SUPER_PALE;
                }
                else {
                    jugstr = Jugadas.PALE;
                }
            }
            else {
                jugstr = Jugadas.PALE;
            }
        }
        else if (Jugadas.isTripleta(numero)) {
            jugstr = Jugadas.TRIPLETA;
        }

        // reseteamos los flags
        isJugadaUpdate = false;
        isSPaleDefined = false;
        isSPale = false;
        isCash3Defined = false;
        isCash3Straight = false;
        isPlay4Defined = false;
        isPlay4Straight = false;

        if (isJugadaUpdate) {
            jugadaUpdate.setNumero(numero);
            jugadaUpdate.setValor(valor);
            jugadaUpdate.setJugstr(jugstr);
            adaptador.notifyDataSetChanged();

            if (StringUtils.containsLetters(loteria)) {
                jugadaUpdate.setLoteriaFromAbreviado(loteria);
            }
            else {
                jugadaUpdate.setLoteriaFromCodigos(loteria);
            }
        }
        else {
            if (validator.isNumeric(loteria)) {
                loteria = Loterias.getIdsFromCodigos(loteria);
            }
            else {
                loteria = Loterias.getIdsFromAbreviados(loteria);
            }

            var jugada = new Jugada(numero, loteria, monto, jugstr);

            // checamos que la jugada no exista, para evitar duplicado
            let jugada_check = Jugadas.existe(jugada);
            if (!jugada_check) {
                addJugada(jugada);
            }
            else {
                // si existe, sumammos los valores
                jugada_check.setValor(jugada_check.getValor2() + jugada.getValor2());
                addJugada(null);
            }
        }
    }

    var setFocusNumero = function() { console.log("setFocusNumero()")
        domNumero.focus();
    }

    var setFocusLoteria = function(clicked) { console.log("setFocusLoteria()")
        console.log("VentaUtils.hasElegirLoteria():"+VentaUtils.hasElegirLoteria());
        if (VentaUtils.hasElegirLoteria()) {
            if (validator.isEmpty(getValorLoteria()) || clicked) {
                openModalElegirLoteria();
            }
            else {
                setFocusMonto();
            }
        }
        else {
            let codigos = Loterias.getCodigosFromAbreviados(getValorLoteria()); console.log("codigos: " + codigos);
            domLoteria.val(codigos);
            domLoteria.focus();
        }
    }

    var setFocusMonto = function() { console.log("setFocusMonto()")
        domMonto.focus();
    }

    var getValNumero = function() {
        return domNumero.val().trim();
    }

    var getValorLoteria = function() {
        return domLoteria.val().trim();
    }

    var getValorMonto = function() {
        return domMonto.val().trim();
    }

    var setOptionsIcons = function() { console.log("VentaActivity.setOptionsIcons()");
        if (!App.isActivePage(Co.PAGE_VENDER)) {
            console.log("NO PAGE VENDER");
            return;
        }

        $('#venta-icon-print').hide();
        $('#venta-icon-sms').hide();
        $('#venta-icon-none').hide();

        if (Empresa.hasTicketSendImpresora()) {
            $('#venta-icon-print').show();
        }

        if (Empresa.hasTicketSendSMS()) {
            $('#venta-icon-sms').show();
        }

        if (Empresa.hasTicketSendNone()) {
            $('#venta-icon-none').show();
        }
    }

    var addJugada = function (jugada) { console.log("venta.addJugada()"); console.log(jugada);
        if (jugada) {
            Jugadas.add(jugada);
        }
        reload();

        // si el numero no esta fijo, reseteamos y enfocamos
        if (!isNumeroFijo) {
            domNumero.val('');
            domNumero.focus();
        }

        // si la loteria no esta fija
        if (!isLoteriaFijo) {
            // si no esta usando abreviado
            console.log("VentaUtils.hasElegirLoteria():"+VentaUtils.hasElegirLoteria());
            if (!VentaUtils.hasElegirLoteria()) {
                domLoteria.val('');

                // si el numero esta fijo, enfocamos la loteria
                if (isNumeroFijo) {
                    domLoteria.focus();
                }
            }
        }

        // si el monto no esta fijo
        if (!isMontoFijo) {
            domMonto.val('');

            // si el numero y la loteria estan fijos, enfocamos el monto
            if (isNumeroFijo && (isLoteriaFijo || VentaUtils.hasElegirLoteria())) {
                domMonto.focus();
            }
        }
    }

    var send = function () {

        // si no hay ninguna jugada
        if (Jugadas.size() == 0) {
            ui.dialogError(_t('ticket_sin_jugadas'));
            return;
        }

        VentaActivity.sendPrinter();

        /*if (Empresa.countTicketOptions() == 1) {
            if (Empresa.hasTicketSendImpresora()) {
                VentaActivity.sendPrinter();
            }
            else if (Empresa.hasTicketSendSMS()) {
                VentaActivity.sendSMS();
            }
            else if (Empresa.hasTicketSendNone()) {
                VentaActivity.sendNone();
            }
        }
        else if (Empresa.countTicketOptions() > 1) {
            var html = '<ul class="nav nav-tabs nav-stacked list-dialog" id="dialog-spale">';
            if (Empresa.hasTicketSendImpresora()) {
                html += '<li id="_printer"><a href="#link">'+ _t('ticket_type_printer') +'</a></li>';
            }
            if (Empresa.hasTicketSendSMS()) {
                html += '<li id="_sms"><a href="#link">'+ _t('ticket_type_sms') +'</a></li>';
            }
            if (Empresa.hasTicketSendNone()) {
                html += '<li id="_none"><a href="#link">'+ _t('ticket_type_none') +'</a></li>';
            }
            html += '</ul>';

            $.confirm({
                useBootstrap: false,
                backgroundDismiss: true,
                title: '',
                content: html,
                buttons: {
                    buttonA: {
                        isHidden: true,
                        text: 'button a',
                        action: function () {
                            this.buttons.buttonB.setText('Changed it!');
                            return false;
                        }
                    },
                    buttonB: {
                        isHidden: true,
                        text: 'button b',
                        action: function () {
                            this.buttons.buttonA.disable();
                            return false;
                        }
                    }
                },
                onContentReady: function () {
                    var modal = this;

                    $('ul#dialog-spale li').keynavigator({
                        activeClass: 'alert-info',
                        keys: {
                            enter: function($el) {
                                var op_selected = $el.attr('id');
                                modal.close();

                                if (op_selected == '_printer') {
                                    sendPrinter();
                                }
                                if (op_selected == '_sms') {
                                    sendSMS();
                                }
                                if (op_selected == '_none') {
                                    sendNone();
                                }
                            }
                        }
                    });

                    $('ul#dialog-spale li:eq(0)').click();
                }
            });
        }
        else {
            ui.dialogError('NO TICKET OPTIONS');
        }*/
    }

    var sendPrinter = function () {
        sendTicket(Co.TICKET_TYPE_PRINTER);
    }

    var sendSMS = function () {
        $.confirm({
            title: '',
            content: '' +
            '<div class="form-group">' +
            '<select class="select2-arrow">' +
            '            <option>Quant Verbal</option>' +
            '            <option>Real Gmat Test</option>' +
            '        <option>Prep test</option>' +
            '        <option>Catprep test</option>' +
            '        </select>' +
            '<input type="text" placeholder="' +_t('contact_name')+ '" class="name form-control" style="margin-top: 5px;" />' +
            '<input type="text" placeholder="' +_t('contact_phone')+ '" class="name form-control" style="margin-top: 2px;" />' +
                '</div>',
            useBootstrap: false,
            buttons: {
                formSubmit: {
                    text: 'Submit',
                    btnClass: 'btn-blue',
                    action: function () {
                        var name = this.$content.find('.name').val();
                        if(!name){
                            $.alert('provide a valid name');
                            return false;
                        }
                        $.alert('Your name is ' + name);
                    }
                },
                cancel: function () {
                    //close
                },
            },
            onContentReady: function () {
                $(".select2-arrow").not('.manual').select2({
                    theme: "arrow"
                });

                // bind to events
                var jc = this;
                this.$content.find('form').on('submit', function (e) {
                    // if the user submits the form by pressing enter in the field.
                    e.preventDefault();
                    jc.$$formSubmit.trigger('click'); // reference the button and click it
                });
            }
        });

        // sendTicket(Co.TICKET_TYPE_SMS);
    }

    var sendNone = function () {
        $.confirm({
            title: '',
            content: '' +
            '<div class="form-group">' +
            '<select class="select2-arrow">' +
            '            <option>Quant Verbal</option>' +
            '            <option>Real Gmat Test</option>' +
            '        <option>Prep test</option>' +
            '        <option>Catprep test</option>' +
            '        </select>' +
            '<input type="text" placeholder="' +_t('contact_name')+ '" class="name form-control" style="margin-top: 5px;" />' +
            '</div>',
            useBootstrap: false,
            buttons: {
                formSubmit: {
                    text: 'Submit',
                    btnClass: 'btn-blue',
                    action: function () {
                        var name = this.$content.find('.name').val();
                        if(!name) {
                            $.alert('provide a valid name');
                            return false;
                        }
                        $.alert('Your name is ' + name);
                    }
                },
                cancel: function () {
                    //close
                },
            },
            onContentReady: function () {
                $(".select2-arrow").not('.manual').select2({theme: "arrow"});

                // bind to events
                var jc = this;
                this.$content.find('form').on('submit', function (e) {
                    // if the user submits the form by pressing enter in the field.
                    e.preventDefault();
                    jc.$$formSubmit.trigger('click'); // reference the button and click it
                });
            }
        });

        //sendTicket(Co.TICKET_TYPE_NONE);
    }

    var sendTicket = function(type) {
        type_venta = type;

        // si no hay ninguna jugada
        if (Jugadas.size() == 0) {
            ui.dialogError(_t('ticket_sin_jugadas'));
            return;
        }

        var jugadas = [], jugada;
        for (var i=0; i<Jugadas.size(); i++) {
            jugada = Jugadas.get(i);
            jugadas.push({
                numero: jugada.getNumero(),
                loteria: jugada.getLoteria(),
                valor: jugada.getValor(),
                jugstr: jugada.getJugstr()
            });
        }

        var data = {
            'action': packet.VENDER,
            'uuid': ut.getTicketUUID(),
            'type_venta': type_venta,
            'jugadas': jugadas
        }

        if (type == Co.TICKET_TYPE_NONE) {
            data['ticket_contact'] = DB.get(DB.CONTACTS_TICKET_NONE_SELECTED, "");
        }
        else if (type == Co.TICKET_TYPE_SMS) {
            data['ticket_contact'] = DB.get(DB.CONTACTS_TICKET_SMS_SELECTED, "");
        }

        ui.loadingStart(_t('ticket_sending'));
        Server.send(data);
    }

    var venderResult = function(data) { console.log("VentaActivity.venderResult()");
        ui.loadingStop();

        if (data.success) {

            // si no hay jugadas, no se imprime nada
            if (Jugadas.size() > 0) {

                // si fue tipo printer, lo imprimirmos
                if (type_venta == Co.TICKET_TYPE_PRINTER) {
                    new PrinterTicket(data.data).print();
                }

                Jugadas.reset();
                reload();
            }
        }
        else {
            ui.dialogError(data.msg);
        }
    }

    var reload = function () { console.log("VentaActivity.reload()");
        domTableJugadas.empty();

        let html;
        let jugadas = Jugadas.getAll();
        jugadas.forEach(function (jugada, index) {
            index = index+1;
            html = '<tr id="tr_venta_' +index+ '">' +
                '<td>' + index + '</td>' +
                '<td>' + jugada.getJugstr() + '</td>' +
                '<td>' + jugada.getNumero2() + '</td>' +
                '<td>' + jugada.getLoteriasAbreviado() + '</td>' +
                '<td style="text-align: right">' + jugada.getValor() + '</td>' +
                '</tr>';

            domTableJugadas.append(html);
        });

        $('#jugadas_total_monto').text('$ ' + Jugadas.totalMonto().formatMoney(0, '.', ','));
    }

    var reloadFromCopy = function(rows) {

        Jugadas.reset();

        var j;
        for (var i=0; i<rows.length; i++) {
            j = rows[i];
            addJugada(new Jugada(j.numero, j.loteria, j.valor, j.jugstr));
        }

        setFocus();
    }

    var onLoteriaLostFocus = function() { console.log("onLoteriaLostFocus()");
        if (VentaUtils.hasElegirLoteria()) {

        }
        else {
            domLoteria.val(Loterias.getAbreviadosFromCodigos(getValorLoteria()));
        }
    }

    var openModalElegirLoteria = function() { console.log("VentaFragment.openModalElegirLoteria(): " + Time.getHHMM());
        const loterias = Loterias.getList();
        let abreviados = [];
        loterias.forEach(function(loteria) {
            if (loteria.isOpen()) {
                abreviados.push(loteria.getAbreviado());
            }
        });

        if (abreviados.length == 0) {
            ui.dialogError("Todas las loterías están cerradas.", "Loterías cerradas!");
            return;
        }

        // checamos si hay valores ingresados
        let loteria;
        let loterias_pre_selected = [];
        if (!validator.isEmpty(getValorLoteria())) {
            let abreviados = getValorLoteria().split(' ');
            if (abreviados.length > 0) {
                for (let i=0; i<abreviados.length; i++) {
                    console.log(abreviados[i]);
                    loteria = Loterias.getFromAbreviado(abreviados[i]); console.log(loteria);
                    loterias_pre_selected.push(Loterias.getFromAbreviado(abreviados[i]).getId());
                }
            }
        }

        let selected = false;
        var html = '<ul class="nav nav-tabs nav-stacked list-dialog" id="dialog-menu">';
        loterias.forEach(function (loteria) {
            if (!loteria.isOpen()) { return; }

            selected = false;
            if (loterias_pre_selected.indexOf(loteria.getId()) >= 0) {
                selected = true;
            }

            html += '<li id="'+loteria.getId()+'">' +
                '<div class="checkbox"><input type="checkbox" id="check-'+loteria.getId()+'" '+(selected?'checked':'')+'>' +
                '<label for="check-'+loteria.getId()+'"><a href="#link">'+loteria.getNombre()+'</a></label>' +
                '</div></li>';
        });
        html += '</ul>';

        $.confirm({
            useBootstrap: false,
            backgroundDismiss: true,
            title: 'Seleccione el tipo de jugada',
            content: html,
            buttons: {
                buttonA: {isHidden: true},
                buttonB: {isHidden: true}
            },
            onContentReady: function () {
                var modal = this;

                $('ul#dialog-menu li').keynavigator({
                    activeClass: 'alert-info',
                    keys: {
                        enter: function($el) {
                            modal.close();

                            let loterias_selected = [];
                            let elements = $el.parent().find(':checkbox');
                            Object.values(elements).forEach(function(element) {
                                element = $(element);
                                if (element.prop('checked')) {
                                    loterias_selected.push(filter.number(element.attr('id')));
                                }
                            });
                            loterias_selected = loterias_selected.unique();

                            let loterias_str = [];
                            loterias_selected.forEach(function (id) {
                                loterias_str.push(Loterias.get(id).getAbreviado());
                            });

                            domLoteria.val(loterias_str.join(' '));
                            domLoteria.prop('disabled', true);
                            domNumero.prop('disabled', true);
                            setFocusMonto();
                            setTimeout(function () {
                                domNumero.prop('disabled', false);
                                domLoteria.prop('disabled', false);
                            },200);
                        },
                        107: function($el) {
                            $el.find(':checkbox').prop('checked', !$el.find(':checkbox').prop('checked'));
                        }
                    }
                });

                $('ul#dialog-menu li:eq(0)').click();
            }
        });
    }

    var init = function () {
        if (!App.isActivePage(Co.PAGE_VENDER)) {
            App.setCurrentPage(Co.PAGE_VENDER);

            initHtml();
            initListeners();
            setFocusNumero();
        }
    }

    return {
        init: init,
        send: send,
        sendPrinter: sendPrinter,
        venderResult: venderResult,
        setOptionsIcons: setOptionsIcons,
        reloadFromCopy: reloadFromCopy,
        addJugadaEval: addJugadaEval,

        definePale: function (_isSPale) {
            isSPaleDefined = true;
            isSPale = _isSPale;
            addJugadaEval();
        },
        defineCash3: function (isStraight) {
            isCash3Defined = true;
            isCash3Straight = isStraight;
            addJugadaEval();
        },
        definePlay4: function (isStraight) {
            isPlay4Defined = true;
            isPlay4Straight = isStraight;
            addJugadaEval();
        }
    }
}();