let VentaUtils = function () {

    let validarNumeric = function(numero) {
        if (validator.isEmpty(numero)) {
            return false;
        }

        if (!validator.isNumeric(numero)) {
            return false;
        }

        return true;
    }

    let hasElegirLoteria = function() {
        return DB.get(DB.CONFIG_JUGADA_SELECCION_LOTERIA) === Co.CONFIG_JUGADA_SELECCION_LOTERIA_SELECCION;
    }

    let validarLoteriaByAbreviado = function(loteria) {
        let r = loteria.split(" ");
        if (r.length === 0) {
            return false;
        }

        for (let i=0; i<r.length; i++) {
            if (!Loterias.getFromAbreviado(r[i])) {
                return false;
            }
        }

        return true;
    }

    let validarLoteriaByCode = function(loteria) {
        let r = loteria.split('');
        if (r.length == 0) {
            return false;
        }

        for (let i=0; i<r.length; i++) {
            if (!Loterias.getFromCode(r[i])) {
                return false;
            }
        }

        return true;
    }

    let validarMonto = function(valor) {
        if (!validator.isFloat(valor)) {
            return false;
        }

        /*valor = valor.split('')[0];
        if (parseInt(valor) < 1) {
            return false;
        }*/

        return true;
    }

    let validarLoteriaCierreByAbreviado = function(abreviado) {
        let r = abreviado.split(' ');
        if (r.length == 0) {
            return false;
        }

        let loteria;
        for (let i=0; i<r.length; i++) {
            loteria = Loterias.getFromAbreviado(r[i]);
            if (!loteria.isOpen()) {
                ui.dialogErrorSimple("Loteria (" + loteria.getNombre() + ") cerrada!");
                return false;
            }
        }

        return true;
    }

    let validarLoteriaCierreByCode = function(codigo) {
        let r = codigo.split('');
        if (r.length == 0) {
            return false;
        }

        let loteria;
        for (let i=0; i<r.length; i++) {
            loteria = Loterias.getFromCode(r[i]);
            if (!loteria.isOpen()) {
                ui.dialogErrorSimple("Loteria (" + loteria.getNombre() + ") cerrada!");
                return false;
            }
        }

        return true;
    }

    let validarNumero = function(numero, loteria) { console.log("VentaUtils.validarNumero()");
        let loterias;

        if (validator.isNumeric(loteria)) {
            loterias = Loterias.getFromCodigos(loteria);
        }
        else {
            loterias = Loterias.getFromAbreviados(loteria);
        }

        let res = true;
        loterias.forEach(function (loteria) { console.log("loteria:" + loteria.getNombre() + " (" + loteria.getFormato() + ")");
            if (loteria.isDominicana()) {console.log("validarNumero() isDominicana:" + loteria.getFormato());
                if (!(isQuiniela(numero) || isPale(numero) || isTripleta(numero))) {
                    res = false;
                }
            }
            else if (loteria.isAmericana()) { console.log("validarNumero() isAmericana:" + loteria.getFormato());
                if (!(isFromBack(numero) || isCash3(numero) || isPlay4(numero))) {
                    res = false;
                }
            }
            else if (loteria.isCash3()) { console.log("validarNumero() isCash3:" + loteria.getFormato());
                if (!isCash3(numero)) {
                    res = false;
                }
            }
            else if (loteria.isPlay4()) { console.log("validarNumero() isPlay4:" + loteria.getFormato());
                if (!isPlay4(numero)) {
                    res = false;
                }
            }
            else if (loteria.isBorlette()) { console.log("validarNumero() isBorlette:" + loteria.getFormato());
                if (!(isBorlette(numero) || isMariage(numero) || isLoto3(numero) || isLoto4(numero) || isLoto5(numero) || isLoto6(numero))) {
                    res = false;
                }
            }
        });

        return res;
    }

    let isQuiniela = function(numero) {
        if (!validator.isNumeric(numero)) {
            return false;
        }

        if (numero.length == 2) {
            return true;
        }

        return false;
    }

    let isPale = function(numero) {

        if (!validator.isNumeric(numero)) {
            return false;
        }

        if (numero.length == 4) {
            return true;
        }

        return false;
    }

    let isTripleta = function(numero) {

        if (!validator.isNumeric(numero)) {
            return false;
        }

        if (numero.length == 6) {
            return true;
        }

        return false;
    }

    let isFromBack = function(numero) {
        if (!validator.isNumeric(numero)) {
            return false;
        }

        if (numero.length == 2) {
            return true;
        }

        return false;
    }

    let isCash3 = function(numero) {
        if (validator.isNumeric(numero) && numero.length == 3) {
            return true;
        }

        return false;
    }

    let isPlay4 = function(numero) {
        if (validator.isNumeric(numero) && numero.length == 4) {
            return true;
        }

        return false;
    }

    let isBorlette = function(numero) {
        if (validator.isNumeric(numero) && numero.length == 2) {
            return true;
        }

        return false;
    }

    let isMariage = function(numero) {
        if (validator.isNumeric(numero) && numero.length == 4) {
            return true;
        }

        return false;
    }

    let isLoto3 = function(numero) {
        if (validator.isNumeric(numero) && numero.length == 3) {
            return true;
        }

        return false;
    }

    let isLoto4 = function(numero) {
        if (validator.isNumeric(numero) && numero.length == 4) {
            return true;
        }

        return false;
    }

    let isLoto5 = function(numero) {
        if (validator.isNumeric(numero) && numero.length == 5) {
            return true;
        }

        return false;
    }

    let isLoto6 = function(numero) {
        if (validator.isNumeric(numero) && numero.length == 6) {
            return true;
        }

        return false;
    }

    let permute = function (nums, len) {
        var result = [];
        var backtrack = (i, nums) => {
            if(i===nums.length){
                result.push(nums.slice());
                return;
            }
            for(let j = i; j < nums.length; j++){
                [nums[i],nums[j]] = [nums[j],nums[i]];
                backtrack(i+1, nums);
                [nums[i],nums[j]] = [nums[j],nums[i]];
            }
        }
        backtrack(0, nums);
        console.log(result);
        return result;
    }

    let permutationString = str => {
        if (str.length <= 2) return str.length === 2 ? [str[0] + str[1], str[1] + str[0]] : [str];
        return str
            .split('')
            .reduce(
                (accumulator, letter, i) =>
                    accumulator.concat(permutationString(str.slice(0, i) + str.slice(i+1)).map(val => letter + val)),[]);
    };
    //console.log(permutationString('abcd'));

    return {
        isQuiniela: isQuiniela,
        isPale: isPale,
        isTripleta: isTripleta,
        isFromBack: isFromBack,
        isCash3: isCash3,
        isPlay4: isPlay4,
        isBorlette: isBorlette,
        isMariage: isMariage,
        isLoto3: isLoto3,
        isLoto4: isLoto4,
        isLoto5: isLoto5,
        isLoto6: isLoto6,
        validarNumeric: validarNumeric,
        hasElegirLoteria: hasElegirLoteria,
        validarLoteriaByAbreviado: validarLoteriaByAbreviado,
        validarLoteriaByCode: validarLoteriaByCode,
        validarMonto: validarMonto,
        validarLoteriaCierreByAbreviado: validarLoteriaCierreByAbreviado,
        validarLoteriaCierreByCode: validarLoteriaCierreByCode,
        validarNumero: validarNumero,
        permute: permute
    }
}();