let VentaTicket = function () {

    let cancelResult = function(data) {
        if (data.success) {
            let ticket = data.ticket;
            TicketAnular.anularCodigo(ticket);
        }
        else {
            ui.dialogError(data.msg);
        }
    }

    let cancelCodeResult = function(data) {
        if (data.success) {
            ui.dialogSuccess(data.msg);
        }
        else {
            ui.dialogError(data.msg);
        }
    }

    let payResult = function(data) {
        if (data.success) {
            Modal.pagarCodigo(data.ticket);
        }
        else {
            if (data.msg && Co.TICKET_PAGADO === data.msg) {
                Modal.pagarSuccess(data);
            }
            else {
                ui.dialogError(data.msg);
            }
        }
    }

    let payCodeResult = function(data) {
        if (data.success) {
            Modal.pagarSuccess(data);
        }
        else {
            ui.dialogError(data.msg);
        }
    }

    let copyResult = function (data) {
        if (!App.isActivePage(Co.PAGE_VENDER)) {
            VentaActivity.init();
        }

        if (data.success) {
            VentaActivity.reloadFromCopy(data.jugadas);
        }
        else {
            ui.dialogErrorSimple(data.msg);
        }
    }

    let combinarResult = function (data) {
        if (!App.isActivePage(Co.PAGE_VENDER)) {
            VentaActivity.init();
        }

        if (data.success) {
            VentaActivity.reloadFromCombinar(data.jugadas);
        }
        else {
            ui.dialogErrorSimple(data.msg);
        }
    }


    return {
        copyResult: copyResult,
        cancelResult: cancelResult,
        cancelCodeResult: cancelCodeResult,
        payResult: payResult,
        payCodeResult: payCodeResult,
        combinarResult: combinarResult,
    }
}();