let ut = function() {


	return {

		exit: function() { console.log("util.exit()")
			throw new Error();
		},
		get_url_param: function(name) {
			return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.search)||[,""])[1].replace(/\+/g, '%20'))||null
		},
		only_number: function(str)  {
			if (!str) { return ""; }
			if (str.length < 1) { return ""; }
			str = str.trim();
			if (str.length < 1) { return ""; }
			return str.replace(/[^0-9]+/g, "");
		},
		only_decimal: function(str)  {
			if (!str) { return ""; }
			if (str.length < 1) { return ""; }
			str = str.trim();
			if (str.length < 1) { return ""; }
			return parseFloat(str.replace(/[^0-9.]+/g, ""));
		},
		remove_numbers: function(str)  {
			if (!str) { return ""; }
			if (str.length < 1) { return ""; }
			str = str.trim();
			if (str.length < 1) { return ""; }
			return str.replace(/[0-9]/g, "");
		},
		format_money: function(number) {
			return number.toFixed(2).replace(/(\d)(?=(\d{3})+\.)/g, '$1,');
		},
		numberMoneyFormat: function(n) {
			let parts = n.toString().split(".");
			parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ",");
			return parts.join(".");
		},
		round: function(n,p) {
			if (!p) { p = 0; }
			let a=[1,10,100,1000,10000,100000,1000000,10000000,100000000,1000000000,10000000000];
			return Math.round(n*a[p])/a[p];
		},
		get_current_url: function () {
			return window.location.href;
		},

		checkStrength: function(password) {
			let strength = 0

			if (password.length >= 6) strength += 1;

			// contains both lower and uppercase characters
			if (password.match(/([a-z].*[A-Z])|([A-Z].*[a-z])/)) strength += 1;

			// it has numbers and characters
			if (password.match(/([a-zA-Z])/) && password.match(/([0-9])/)) strength += 1;

			// it has one special character
			if (password.match(/([!,%,&,@,#,$,^,*,?,_,~])/)) strength += 1;

			// it has two special characters, increase strength value.
			if (password.match(/(.*[!,%,&,@,#,$,^,*,?,_,~].*[!,%,&,@,#,$,^,*,?,_,~])/)) strength += 1;

			if (password.length >= 12) strength += 1;

			let desc = new Array();
			desc[0] = "muy d&eacute;bil";
			desc[1] = "d&eacute;bil";
			desc[2] = "regular";
			desc[3] = "buena";
			desc[4] = "fuerte";
			desc[5] = "muy fuerte";

			$("#passwordDescription").html(desc[strength]);

			$("#passwordStrength").removeClass();
			if (strength > 0) {
				$("#passwordStrength").addClass("strength" + strength);
			}
		},

        format_size: function(size) {
            let i = Math.floor( Math.log(size) / Math.log(1024) );
            return ( size / Math.pow(1024, i) ).toFixed(2) * 1 + ' ' + ['B', 'kB', 'MB', 'GB', 'TB'][i];
        },

        time: function(in_seconds) {
        	if (in_seconds === true) {
				return Math.floor(new Date().getTime() / 1000);
			}
			else {
				return new Date().getTime();
			}
        },

        getTicketUUID: function () {
            return Date.now().toString();
        },

		splitBy2: function (s) {
            return s.match(/.{1,2}/g);
        },

		isPair: function (n) {
			return (n % 2) === 0;
        },

        isSubdomain: function(url) {
            url = url || window.location.href;
            let regex = new RegExp(/^([a-z]+\:\/{2})?([\w-]+\.[\w-]+\.\w+)$/);

            return !!url.match(regex);
        },

		shadeColor: function(color, percent) {

			let R = parseInt(color.substring(1,3),16);
			let G = parseInt(color.substring(3,5),16);
			let B = parseInt(color.substring(5,7),16);

			R = parseInt(R * (100 + percent) / 100);
			G = parseInt(G * (100 + percent) / 100);
			B = parseInt(B * (100 + percent) / 100);

			R = (R<255)?R:255;
			G = (G<255)?G:255;
			B = (B<255)?B:255;

			let RR = ((R.toString(16).length==1)?"0"+R.toString(16):R.toString(16));
			let GG = ((G.toString(16).length==1)?"0"+G.toString(16):G.toString(16));
			let BB = ((B.toString(16).length==1)?"0"+B.toString(16):B.toString(16));

			return "#"+RR+GG+BB;
		},

		datePikerLocale: function () {
			return {
				"locale": {
					"format": "DD/MM/YYYY",
						"separator": " - ",
						"applyLabel": "Aceptar",
						"cancelLabel": "Cancelar",
						"fromLabel": "Desde",
						"toLabel": "Hasta",
						"customRangeLabel": "Custom",
						"daysOfWeek": [
						"Do",
						"Lu",
						"Ma",
						"Mi",
						"Ju",
						"Vi",
						"Sa"
					],
					"monthNames": [
						"Enero",
						"Febrero",
						"Marzo",
						"Abril",
						"Mayo",
						"Junio",
						"Julio",
						"Agosto",
						"Septiembre",
						"Octubre",
						"Noviembre",
						"Diciembre"
					],
						"firstDay": 1
				}
			}
		},

        generateTicketNumero: function(ticketId) {
            return ticketId.toString().substr(4,10);
        },

		powerset: function(data) {
			const subsets = [[]];

			for (const el of data) {
				const last = subsets.length-1;
				for (let i = 0; i <= last; i++) {
					subsets.push( [...subsets[i], el] );
				}
			}

			return subsets;
		},
		jugadasSort: function( a, b ) {
			return a.len - b.len || a.numero.localeCompare(b.numero);
		}
	}

}();

String.prototype.toBytes = function() {
	let arr = []
	for (let i=0; i < this.length; i++) {
		arr.push(this[i].charCodeAt(0));
	}
	return arr;
}

Number.prototype.formatMoney = function(c, d, t){
	var n = this,
		c = isNaN(c = Math.abs(c)) ? 2 : c,
		d = d == undefined ? "." : d,
		t = t == undefined ? "," : t,
		s = n < 0 ? "-" : "",
		i = String(parseInt(n = Math.abs(Number(n) || 0).toFixed(c))),
		j = (j = i.length) > 3 ? j % 3 : 0;
	return s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "");
};

Array.prototype.last = function(){
	return this[this.length - 1];
};

Array.prototype.unique = function() {
    return this.filter(function (value, index, self) {
        return self.indexOf(value) === index;
    });
}

function select2Icons (state) {
	if (!state.id) { return state.text; }
	let $state = $('<span class="font-icon ' + state.element.getAttribute('data-icon') + '"></span><span>' + state.text + '</span>');
	return $state;
}