let ui = function() {
    "use strict";

	return {

		progreStart: function() {
			NProgress.start();
		},
		progreStop: function() {
			NProgress.done();
		},

		block: function(msg) {
			if (msg && typeof msg === 'string') {
				App.blockUI({boxed:true, message:msg});
			}
			else {
				App.blockUI({boxed:true});
			}
		},

		unblock: function() {
			App.unblockUI();
		},

		loadingShow: function() {
			App.startPageLoading({animate: true});
		},

		loadingHide: function() {
			App.stopPageLoading();
		},

		loadingStart: function(text) {
			$('body').loadingModal({text: text, 'animation': 'doubleBounce'});
		},

		loadingStop: function() {
			$('body').loadingModal('destroy');
		},


		dialogError: function (msg, title) {
			$.confirm({
				title: title?title:'Error',
				content: msg?msg:'',
				type: 'red',
				theme: 'dark',
				useBootstrap: false,
				closeIcon: true,
				closeIconClass: 'fa fa-close',
				typeAnimated: true,
				boxWidth: '40%',
				escapeKey: 'okay',
				buttons: {
					okay: {
						text: 'OK',
						keys: ['enter']
					},
				}
			});
		},

		dialogErrorSimple: function (msg, callback) {
			$.confirm({
				title: '',
				content: msg,
				type: 'red',
				escapeKey: 'okay',
				buttons: {
					okay: {
						text: 'OK',
						keys: ['enter'],
						action: callback
					},
				}
			});
		},

        dialogInfo: function (msg, title, callback) {
			$.confirm({
				title: title?title:'Error',
				content: msg?msg:'',
				type: 'blue',
				closeIcon: true,
				closeIconClass: 'fa fa-close',
				typeAnimated: true,
				buttons: {
					tryAgain: {
						text: 'OK',
						btnClass: 'btn-red',
						action: callback
					}
				}
			}).setDialogCenter();
        },

		dialogSuccess: function (msg, title) {
			$.confirm({
				title: title?title:'',
				content: msg?msg:'',
				type: 'blue',
				useBootstrap: false,
				closeIcon: true,
				closeIconClass: 'fa fa-close',
				typeAnimated: true,
				boxWidth: '40%',
				buttons: {
					okay: {
						text: 'OK',
						keys: ['enter']
					},
				}
			});
		},

		toast: {
			s: function(msg, title) {
				if (title) {
					toastr.success(msg, title);
				}
				else {
					toastr.success(msg);
				}
			},
			i: function(msg, title) {
				if (title) {
					toastr.info(msg, title);
				}
				else {
					toastr.info(msg);
				}
			},
			w: function(msg, title) {
				if (title) {
					toastr.warning(msg, title);
				}
				else {
					toastr.warning(msg);
				}
			},
			e: function(msg, title) {
				if (title) {
					toastr.error(msg, title);
				}
				else {
					toastr.error(msg);
				}
			}
		},

		notiDefault: function(msg,title) {
			Lobibox.notify('default', {
				msg: msg,
				title: title ? title : null,
				pauseDelayOnHover: true,
				continueDelayOnInactiveTab: true,
				size: 'mini',
			});
		},

		notiInfo: function(msg,title) {
			Lobibox.notify('info', {
				msg: msg,
				title: title ? title : null,
				pauseDelayOnHover: true,
				continueDelayOnInactiveTab: true,
				size: 'mini',
				//delayIndicator: false,
				//delay: 990000
			});
		},

		notiWarning: function(msg,title) {
			Lobibox.notify('warning', {
				msg: msg,
				title: title ? title : null,
				pauseDelayOnHover: true,
				continueDelayOnInactiveTab: true,
				size: 'mini',
			});
		},

		notiError: function(msg,title) {
			Lobibox.notify('error', {
				msg: msg,
				title: title ? title : null,
				pauseDelayOnHover: true,
				continueDelayOnInactiveTab: true,
				size: 'mini',
			});
		},

		notiSuccess: function(msg,title) {
			Lobibox.notify('success', {
				msg: msg,
				title: title ? title : null,
				pauseDelayOnHover: true,
				continueDelayOnInactiveTab: true,
				size: 'mini',
			});
		},

        notiNotify: function(msg,title) {
            Lobibox.notify('warning', {
            	sound: 'sound1',
                msg: msg,
                title: title ? title : null,
                pauseDelayOnHover: true,
                continueDelayOnInactiveTab: true,
                size: 'mini',
				delay: 20000
            });
        },

        loginModal: function () {

        	/*if ($('.bootbox-prompt').is(':visible:')) {
        		return;
			}*/

			if($('.bootbox-prompt').hasClass('in') ) {
				return;
			}

            let username = Cookies.get(Co.COOKIE_NAME_USERNAME);

            if (username) {
                bootbox.prompt({
                    title: "Ingrese su clave de usuario",
                    buttons: {
                        confirm: {
                            label: 'Aceptar',
                            className: 'btn-success'
                        },
                        cancel: {
                            label: 'Cancelar',
                            className: 'btn-danger'
                        }
                    },
                    inputType: 'password',
                    callback: function (password) {
                        Ajax.exe('/login', {'username': username, 'password': password}, function (data) {
                            if (data.success) {
                                ui.toast.s('Sesion actualizada');
                                //$('.bootbox.modal').modal('hide');
                            }
                            else {
                                ui.toast.e('Clave incorrecta');
                            }
                        });
                    }
                });
            }
            else {
                location.reload(true);
            }
        }
	}
}();