let TicketCombinar = function () {

    // numeros a combinar
    let combinar = function () {
        let data = {};

        $.confirm({
            escapeKey: true,
            backgroundDismiss: true,
            title: 'Digite los números',
            content: '<div class="form-group"><input type="text" class="input-ticket form-control"/></div>',
            buttons: {
                formSubmit: {
                    text: _t('accept'),
                    btnClass: 'btn-blue',
                    action: function () {
                        let jc = this;
                        let element = jc.$content.find('.input-ticket');
                        let numeros = filter.number(element.val());

                        if (!numeros) {
                            ui.dialogErrorSimple(_t('Digite los números a combinar'), function(){element.focus();});
                            return false;
                        }

                        if (!ut.isPair(numeros.length)) {
                            ui.dialogErrorSimple(_t('Número no válido'), function(){element.focus();});
                            return false;
                        }

                        data.numeros = numeros;
                        combinar2(data);
                    }
                },
                cancel: function () {
                    //close
                },
            },
            onContentReady: function () {
                // bind to events
                let jc = this;
                let element = jc.$content.find('.input-ticket');
                element.on('keypress', function (e) {
                    if (e.which == 13) {
                        e.preventDefault();
                        jc.$$formSubmit.trigger('click');
                    }
                });

                element.on('keyup', function (e) {
                    let val = filter.number(element.val()); console.log(val);
                    element.val(val.match(/.{1,2}/g).join('-'));
                });

                element.focus();
            }
        });
    }

    // tipo jugadas
    let combinar2 = function (data) {
        let html = '<ul class="nav nav-tabs nav-stacked list-dialog" id="dialog-menu">' +
            '<li><div class="checkbox"><input type="checkbox" id="make_quiniela">' +
            '   <label for="make_quiniela"><a href="#link">Quiniela</a></label>' +
            '</div></li>' +
            '<li><div class="checkbox"><input type="checkbox" id="make_pale">' +
            '   <label for="make_pale"><a href="#link">Palé</a></label>' +
            '</div></li>' +
            '<li><div class="checkbox"><input type="checkbox" id="make_tripleta">' +
            '   <label for="make_tripleta"><a href="#link">Tripleta</a></label>' +
            '</div></li>' +
            '<li><div class="checkbox"><input type="checkbox" id="make_spale">' +
            '   <label for="make_spale"><a href="#link">Super Palé</a></label>' +
            '</div></li>' +
            '</ul>';

        $.confirm({
            escapeKey: true,
            backgroundDismiss: true,
            useBootstrap: false,
            title: 'Seleccionar jugadas',
            content: html,
            buttons: {
                buttonA: {isHidden: true},
                buttonB: {isHidden: true}
            },
            onContentReady: function () {
                let modal = this;

                $('ul#dialog-menu li').keynavigator({
                    activeClass: 'alert-info',
                    keys: {
                        enter: function ($el) {
                            modal.close();

                            let elements = $el.parent().find(':checkbox');
                            Object.values(elements).forEach(function (element) {
                                element = $(element);
                                if (element.prop('checked')) {
                                    data[element.attr('id')] = 1;
                                }
                            });

                            combinar3(data)
                        },
                        107: function ($el) {
                            $el.find(':checkbox').prop('checked', !$el.find(':checkbox').prop('checked'));
                        }
                    }
                });

                $('ul#dialog-menu li:eq(0)').click();
            }
        });
    }

    // monto quiniela
    let combinar3 = function (data) { console.log(data);
        if (!data.make_quiniela) {
            return combinar4(data);
        }

        $.confirm({
            escapeKey: true,
            backgroundDismiss: true,
            title: 'Monto Quiniela',
            content: '<div class="form-group"><input type="number" placeholder="$" class="input-ticket form-control"/></div>',
            buttons: {
                formSubmit: {
                    text: _t('accept'),
                    btnClass: 'btn-blue',
                    action: function () {
                        let jc = this;
                        let element = jc.$content.find('.input-ticket');
                        let monto = filter.int(element.val());
                        if (!monto) {
                            ui.dialogErrorSimple('Monto no válido', function(){element.focus();});
                            return false;
                        }

                        data.monto_quiniela = monto;
                        combinar4(data);
                    }
                },
                cancel: function () {},
            },
            onContentReady: function () {
                let jc = this;
                let element = jc.$content.find('.input-ticket');
                element.on('keypress', function (e) {
                    if (e.which == 13) {
                        e.preventDefault();
                        jc.$$formSubmit.trigger('click');
                    }
                });

                element.focus();
            }
        });
    }

    // monto pale
    let combinar4 = function (data) { console.log(data);
        if (!data.make_pale) {
            return combinar5(data);
        }

        $.confirm({
            escapeKey: true,
            backgroundDismiss: true,
            title: 'Monto Palé',
            content: '<div class="form-group"><input type="number" placeholder="$" class="input-ticket form-control"/></div>',
            buttons: {
                formSubmit: {
                    text: _t('accept'),
                    btnClass: 'btn-blue',
                    action: function () {
                        let jc = this;
                        let element = jc.$content.find('.input-ticket');
                        let monto = filter.int(element.val());
                        if (!monto) {
                            ui.dialogErrorSimple('Monto no válido', function(){element.focus();});
                            return false;
                        }

                        data.monto_pale = monto;
                        combinar5(data);
                    }
                },
                cancel: function () {
                    //close
                },
            },
            onContentReady: function () {
                let jc = this;
                let element = jc.$content.find('.input-ticket');
                element.on('keypress', function (e) {
                    if (e.which == 13) {
                        e.preventDefault();
                        jc.$$formSubmit.trigger('click');
                    }
                });

                element.focus();
            }
        });
    }

    // monto tripleta
    let combinar5 = function (data) { console.log(data);
        if (!data.make_tripleta) {
            return combinar6(data);
        }

        $.confirm({
            escapeKey: true,
            backgroundDismiss: true,
            title: 'Monto Tripleta',
            content: '<div class="form-group"><input type="number" placeholder="$" class="input-ticket form-control"/></div>',
            buttons: {
                formSubmit: {
                    text: _t('accept'),
                    btnClass: 'btn-blue',
                    action: function () {
                        let jc = this;
                        let element = jc.$content.find('.input-ticket');
                        let monto = filter.int(element.val());
                        if (!monto) {
                            ui.dialogErrorSimple('Monto no válido', function(){element.focus();});
                            return false;
                        }

                        data.monto_tripleta = monto;
                        combinar6(data);
                    }
                },
                cancel: function () {
                    //close
                },
            },
            onContentReady: function () {
                let jc = this;
                let element = jc.$content.find('.input-ticket');
                element.on('keypress', function (e) {
                    if (e.which == 13) {
                        e.preventDefault();
                        jc.$$formSubmit.trigger('click');
                    }
                });

                element.focus();
            }
        });
    }

    // monto super pale
    let combinar6 = function (data) { console.log(data);
        if (!data.make_spale) {
            return combinar7(data);
        }

        $.confirm({
            escapeKey: true,
            backgroundDismiss: true,
            title: 'Monto Super Palé',
            content: '<div class="form-group"><input type="number" placeholder="$" class="input-ticket form-control"/></div>',
            buttons: {
                formSubmit: {
                    text: _t('accept'),
                    btnClass: 'btn-blue',
                    action: function () {
                        let jc = this;
                        let element = jc.$content.find('.input-ticket');
                        let monto = filter.int(element.val());
                        if (!monto) {
                            ui.dialogErrorSimple('Monto no válido', function(){element.focus();});
                            return false;
                        }

                        data.monto_spale = monto;
                        combinar7(data);
                    }
                },
                cancel: function () {},
            },
            onContentReady: function () {
                let jc = this;
                let element = jc.$content.find('.input-ticket');
                element.on('keypress', function (e) {
                    if (e.which == 13) {
                        e.preventDefault();
                        jc.$$formSubmit.trigger('click');
                    }
                });

                element.focus();
            }
        });
    }

    // loterias
    let combinar7 = function (data) {
        let html = '<ul class="nav nav-tabs nav-stacked list-dialog" id="dialog-menu">';
        const loterias = Loterias.getList();
        loterias.forEach(function (loteria) {
            if (!loteria.isOpen()) {
                return;
            }
            html += '<li id="' + loteria.getId() + '">' +
                '<div class="checkbox"><input type="checkbox" id="check-' + loteria.getId() + '">' +
                '<label for="check-' + loteria.getId() + '"><a href="#link">' + loteria.getNombre() + '</a></label>' +
                '</div></li>';
        });
        html += '</ul>';

        $.confirm({
            escapeKey: true,
            backgroundDismiss: true,
            useBootstrap: false,
            title: 'Seleccionar Loterías',
            content: html,
            buttons: {
                buttonA: {isHidden: true},
                buttonB: {isHidden: true}
            },
            onContentReady: function () {
                let modal = this;

                $('ul#dialog-menu li').keynavigator({
                    activeClass: 'alert-info',
                    keys: {
                        enter: function ($el) {
                            modal.close();

                            let loterias_selected = [];
                            let elements = $el.parent().find(':checkbox');
                            Object.values(elements).forEach(function (element) {
                                element = $(element);
                                if (element.prop('checked')) {
                                    loterias_selected.push(filter.number(element.attr('id')));
                                }
                            });
                            loterias_selected = loterias_selected.unique();

                            data.loterias = loterias_selected.join(',');

                            combinar8(data);
                        },
                        107: function ($el) {
                            $el.find(':checkbox').prop('checked', !$el.find(':checkbox').prop('checked'));
                        }
                    }
                });

                $('ul#dialog-menu li:eq(0)').click();
            }
        });
    }

    let combinar8 = function (data) { console.log(data)
        //data.action = packet.COMBINAR;
        //Server.send(data);

        Jugadas.reset();

        let loterias = data.loterias.split(","); //console.log("lot:"); console.log(loterias);
        let numeros = data.numeros; //console.log(numeros);
        let list = numeros.match(/.{1,2}/g);//console.log(list);

        let set = ut.powerset(list); //console.log(set);

        let jugadas = [];
        let i,j,k;
        let loteria,jugada;

        // loop a las loterias
        for (i=0; i<loterias.length; i++) {
            //if ((i+1) >= len) { break; }

            loteria = loterias[i];

            for (j=0; j<set.length; j++) {
                //jugada = ticket.splitNumeros(set[j]).sort().join('');
                jugada = set[j].sort().join("");console.log(jugada)

                // quinielas
                if (VentaUtils.isQuiniela(jugada)) {
                    if (data.make_quiniela) {
                        jugadas.push({
                            'jugstr': Jugadas.QUINIELA,
                            'valor': data.monto_quiniela,
                            'loteria': loteria,
                            'numero': jugada,
                            'len': jugada.length
                        })
                    }
                }

                // pales
                else if (VentaUtils.isPale(jugada)) {
                    if (data.make_pale) {
                        jugadas.push({
                            'jugstr': Jugadas.PALE,
                            'valor': data.monto_pale,
                            'loteria': loteria,
                            'numero': jugada,
                            'len': jugada.length
                        })
                    }
                }

                // tripleta
                else if (VentaUtils.isTripleta(jugada)) {
                    if (data.make_tripleta) {
                        jugadas.push({
                            'jugstr': Jugadas.TRIPLETA,
                            'valor': data.monto_tripleta,
                            'loteria': loteria,
                            'numero': jugada,
                            'len': jugada.length
                        })
                    }
                }
            }
        }

        // manejo de super pales
        var set_loterias = ut.powerset(loterias); console.log(set_loterias);
        if (data.make_spale) {
            for (k=0; k<set_loterias.length; k++) { //log(set_loterias[k]+' '+set_loterias[k].length);
                if  (set_loterias[k].length === 2) {

                    for (j=0; j<set.length; j++) {
                        //jugada = ticket.splitNumeros(set[j]).sort().join('');
                        jugada = set[j].sort().join("");console.log(jugada)

                        if (VentaUtils.isPale(jugada)) {
                            jugadas.push({
                                'jugstr': Jugadas.SUPER_PALE,
                                'valor': data.monto_spale,
                                'loteria': set_loterias[k],
                                'numero': jugada,
                                'len': jugada.length
                            });
                        }
                    }
                }
            }
        }

        //console.log(jugadas);
        jugadas.sort(ut.jugadasSort);
        //console.log(jugadas);
        //
        //console.log(jugadas)
        VentaActivity.reloadFromCombinar(jugadas);
    }

    return {
        combinar: combinar
    }
}();

