let SorteosActivity = function () {
    "use strict";

    let sorteos;
    let dom = App.getContainerMain();

    let initHtml = function () {
        dom.empty();

        let html = '' +
            '<section class="box-typical">' +
            '   <header class="box-typical-header">' +
            '       <div class="tbl-row">' +
            '           <div class="tbl-cell tbl-cell-title col-md-2"><h3>Sorteos</h3></div>' +
            '           <div class="tbl-cell tbl-cell-title col-md-3">' +
            '               <div class="input-group date">' +
            '                   <input id="daterange_fecha" type="text" class="form-control">' +
            '                   <span class="input-group-addon"><i class="font-icon font-icon-calend"></i></span>' +
            '               </div>' +
            '           </div>' +
            '           <div class="tbl-cell tbl-cell-action-bordered"><button type="button" class="action-btn" id="sorteos-icon-print"><i class="fa fa-print" aria-hidden="true"></i></button></div>' +
            '       </div>' +
            '   </header>' +
            '   <div class="box-typical-body typical-body2" style="xwidth: calc(100% - 240px);">' +
            '       <div class="table-responsive">' +
            '           <table id="table_sorteos" class="table table-bordered table-hover table-sm">' +
            '               <thead>' +
            '                   <tr>' +
            '                       <th>Lotería</th>' +
            '                       <th width="20%">Primera</th>' +
            '                       <th width="20%">Segunda</th>' +
            '                       <th width="20%">Tercera</th>' +
            '                   </tr>' +
            '               </thead>' +
            '               <tbody></tbody>' +
            '           </table>' +
            '       </div>' +
            '   </div>' +
            '</section>';

        dom.append(html);
    }

    let initListener = function () {

        let dateOps = ut.datePikerLocale();
        dateOps.singleDatePicker = true;
        $('#daterange_fecha').daterangepicker(dateOps);
        $('#daterange_fecha').on('hide.daterangepicker', function() {
            initRequest();
        });

        $('div').on('click', 'button#sorteos-icon-print', function (e) {
            e.stopPropagation();
            PrinterSorteos.print($("#daterange_fecha").val(), sorteos);
        });
    }

    let initRequest = function () {
        Server.send({
            'action': packet.SORTEOS,
            'fecha': $("#daterange_fecha").val(),
        });
    }

    let onData = function (data) {

        let table = $('#table_sorteos tbody');
        table.empty();

        sorteos = data.sorteos;
        let i,s,sorteo;
        for (i=0; i<sorteos.length; i++) {
            s = sorteos[i];
            sorteo = new Sorteo(s.loteria_id, s.primera, s.segunda, s.tercera);

            let html = '<tr>' +
                '<td>' + sorteo.getLoteria() + '</td>' +
                '<td>' + sorteo.getPrimera() + '</td>' +
                '<td>' + sorteo.getSegunda() + '</td>' +
                '<td>' + sorteo.getTercera() + '</td>' +
                '</tr>';

            table.append(html);
        }
    }

    let print = function () {
        PrinterSorteos.print($("#daterange_fecha").val(), sorteos);
    }

    let init = function () {
        if (!App.isActivePage(Co.PAGE_SORTEOS)) {
            App.setCurrentPage(Co.PAGE_SORTEOS);

            initHtml();
            $("#daterange_fecha").val(Time.fecha("DD/MM/YYYY"));

            initListener();
            initRequest();
        }
    }

    return {
        init: init,
        onData: onData,
        print: print
    }
}();