let ReporteActivity = function () {
    "use strict";

    let dom = App.getContainerMain();

    let reporte = {
        fecha: "",
        ventas: 0,
        comision: 0,
        premios: 0,
        resultado: 0,
        recargas: 0,
        recargas_comision: 0,
        comision_total: 0,
        has_recargas: false
    };

    let initHtml = function () {
        dom.empty();

        let html = '' +
            '<section class="box-typical">' +
            '   <header class="box-typical-header">' +
            '       <div class="tbl-row">' +
            '           <div class="tbl-cell tbl-cell-title col-md-2"><h3>Reporte de Ventas</h3></div>' +
            '           <div class="tbl-cell tbl-cell-title col-md-3">' +
            '               <div class="input-group date">' +
            '                   <input id="daterange_fecha_desde" type="text" class="form-control">' +
            '                   <span class="input-group-addon"><i class="font-icon font-icon-calend"></i></span>' +
            '               </div>' +
            '           </div>' +
            '           <div class="tbl-cell tbl-cell-title col-md-3">' +
            '               <div class="input-group date">' +
            '                   <input id="daterange_fecha_hasta" type="text" class="form-control">' +
            '                   <span class="input-group-addon"><i class="font-icon font-icon-calend"></i></span>' +
            '               </div>' +
            '           </div>' +
            '           <div class="tbl-cell tbl-cell-action-bordered"><button type="button" class="action-btn" id="sorteos-icon-print"><i class="fa fa-print" aria-hidden="true"></i></button></div>' +
            '       </div>' +
            '   </header>' +
            '   <div class="box-typical-body typical-body2">' +
            '       <div class="table-responsive">' +
            '           <table id="table_header" class="table table-bordered tb-no-border" style="font-size: 20px;">' +
            '               <tr><td align="center" id="empresa_nombre" class="font-weight-bold">-</td></tr>' +
            '               <tr><td align="center" id="empresa_eslogan">-</td></tr>' +
            '               <tr><td align="center" id="fecha">-</td></tr>' +
            '               <tr><td align="center" id="vendedor">-</td></tr>' +
            '               <tr><td align="center"><hr></td></tr>' +
            '           </table>' +
            '           <table id="table_loterias" class="table table-bordered tb-no-border" style="font-size: 20px;" data-striped="true">' +
            '               <tr><td align="center" class="font-weight-bold">Resumen por Loterías</td></tr>' +
            '               <tr><td align="center">' +
            '                   <table id="table_loterias_content" class="table table-bordered tb-no-border" style="width: 90%;font-size:20px;" data-striped="true">' +
            '                       <tbody></tbody>' +
            '                   </table>' +
            '               </td></tr>' +
            '               <tr><td align="center"><hr></td></tr>' +
            '           </table>' +
            '           <table class="table table-bordered tb-no-border" data-striped="true" style="font-size:20px;">' +
            '               <tr><td align="center" colspan="2" id="empresa_nombre" class="font-weight-bold">Resumen General</td></tr>' +
            '               <tr><td align="center">' +
            '                   <table class="table table-bordered tb-no-border" style="width:90%;font-size:20px;" data-striped="true">' +
            '                      <tr id="tr_resumen_recargas">' +
            '                           <td align="left" width="50%">Recargas</td>' +
            '                           <td align="right" id="resumen_recargas">0</td>' +
            '                       </tr>' +
            '                       <tr id="tr_resumen_ventas">' +
                    '                   <td align="left" width="50%">Ventas</td>' +
                    '                   <td align="right" id="resumen_ventas">0</td>' +
                    '               </tr>' +
                    '               <tr id="tr_resumen_premios">' +
                    '                   <td align="left">Premios</td>' +
                    '                   <td align="right" id="resumen_premios">0</td>' +
                    '               </tr>' +
                    '               <tr id="tr_resumen_comision">' +
                    '                   <td align="left">Comisión</td>' +
                    '                   <td align="right" id="resumen_comision">0</td>' +
                    '               </tr>' +
                    '               <tr id="tr_resumen_comision_recargas">' +
                    '                   <td align="left">Comisión Recargas</td>' +
                    '                   <td align="right" id="resumen_comision_recargas">0</td>' +
                    '               </tr>' +
                    '               <tr id="tr_resumen_resultado">' +
                    '                   <td align="left">Resultado</td>' +
                    '                   <td align="right" id="resumen_resultado">0</td>' +
                    '               </tr>' +
            '                   </table>' +
            '               </td></tr>' +
            '           </table>' +
            '       </div>' +
            '   </div>' +
            '</section>';

        dom.append(html);

        $("#daterange_fecha_desde").val(Time.fecha("DD/MM/YYYY"));
        $("#daterange_fecha_hasta").val(Time.fecha("DD/MM/YYYY"));
    }

    let initListener = function () {

        let dateOps = ut.datePikerLocale();
        dateOps.singleDatePicker = true;

        $('#daterange_fecha_desde').daterangepicker(dateOps);
        $('#daterange_fecha_desde').on('hide.daterangepicker', function() {
            initRequest();
        });

        $('#daterange_fecha_hasta').daterangepicker(dateOps);
        $('#daterange_fecha_hasta').on('hide.daterangepicker', function() {
            initRequest();
        });

        $('div').on('click', 'button#sorteos-icon-print', function (e) {
            e.stopPropagation();
            new PrinterReporte(reporte).print();
        });
    }

    let initRequest = function () {
        Server.sending({
            'action': packet.REPORTE,
            'fecha_desde': $("#daterange_fecha_desde").val(),
            'fecha_hasta': $("#daterange_fecha_hasta").val(),
        });
    }

    let onData = function (data) {

        let table = dom.find('#table_loterias_content tbody');
        table.empty();

        let resumen_loterias = data.resumen_loterias;
        for (let i=0; i<resumen_loterias.length; i++) {
            let row = resumen_loterias[i]; console.log(row);

            let html = '<tr><td align="center" colspan="4"><br>' + row.loteria + '</td></tr>' +
                '<tr><td align="right" width="30%">Venta:</td><td align="right" ">' + row.ventas + '</td></tr>' +
                '<tr><td align="right" width="30%">Comisión:</td><td align="right" ">' + row.premios + '</td></tr>' +
                '<tr><td align="right" width="30%">Premios:</td><td align="right" ">' + row.comision + '</td></tr>' +
                '<tr><td align="right" width="30%">Balance:</td><td align="right" class="font-weight-bold">' + row.balance + '</td></tr>';

            table.append(html);
        }

        reporte.fecha = data.fecha;
        reporte.ventas = data.ventas;
        reporte.comision = data.comision;
        reporte.premios = data.premios;
        reporte.resultado = data.resultado;
        reporte.recargas_comision = data.recargas_comision;
        reporte.comision_total = data.comision_total;
        reporte.has_recargas = data.has_recargas;

        dom.find('#empresa_nombre').text(Empresa.getNombre());
        dom.find('#empresa_eslogan').text(Empresa.getEslogan());
        dom.find('#fecha').text(reporte.fecha);
        dom.find('#vendedor').text(Vendedor.getNombre());

        if (reporte.has_recargas) {
            dom.find('#tr_resumen_recargas').show();
            dom.find('#tr_resumen_comision_recargas').show();
        }
        else {
            dom.find('#tr_resumen_recargas').hide();
            dom.find('#tr_resumen_comision_recargas').hide();
        }

        dom.find('#resumen_recargas').text(reporte.recargas);
        dom.find('#resumen_ventas').text(reporte.ventas);
        dom.find('#resumen_premios').text(reporte.premios);
        dom.find('#resumen_comision').text(reporte.comision);
        dom.find('#resumen_comision_recargas').text(reporte.recargas_comision);
        dom.find('#resumen_resultado').text(reporte.resultado);
    }

    let init = function () {
        if (!App.isActivePage(Co.PAGE_REPORTE)) {
            App.setCurrentPage(Co.PAGE_REPORTE);

            initHtml();


            initListener();
            initRequest();
        }
    }

    return {
        init: init,
        onData: onData,
        print: print
    }
}();