let PrinterSorteos = function () {
    "use strict";

    let print = function (fecha, sorteos) {
        Printer.reset();
        Printer.fontA();
        Printer.center();

        Printer.line("RESULTADOS DE LOTERIAS");
        Printer.line("Fecha: " + fecha);
        Printer.br(2);

        Printer.left();
        for (let i=0; i<sorteos.length; i++) {
            let s = sorteos[i];
            let sorteo = new Sorteo(s.loteria_id, s.primera, s.segunda, s.tercera);

            if (Co.PRINTER_TYPE_80MM == Empresa.getPrinterTipo()) {
                Printer.write("".padEnd(5));
                Printer.write(sorteo.getLoteria().padEnd(20));
                Printer.write(sorteo.getPrimera().padEnd(8));
                Printer.write(sorteo.getSegunda().padEnd(8));
                Printer.write(sorteo.getTercera());
                Printer.br();
            }
            else {
                Printer.write(sorteo.getLoteria().padEnd(17));
                Printer.write(sorteo.getPrimera().padStart(5));
                Printer.write(sorteo.getSegunda().padStart(5));
                Printer.write(sorteo.getTercera().padStart(5));
                Printer.br();
            }
        }

        Printer.br(5);

        Printer.print();
    }

    return {
        print: print
    }
}();