let PrinterRecarga = function (data) {
    "use strict";

    this.company = data["company"];
    this.telefono = data["telefono"];
    this.monto = data["monto"];
    this.idTransaction = data["id_transaccion"];
    this.fecha = data["fecha"];
}

PrinterRecarga.prototype.print = function() {
    Printer.reset();

    Printer.fontA();
    Printer.center();

    Printer.emphasized();
    Printer.underline();
    Printer.line(Empresa.getNombre());
    Printer.underlineOff();
    Printer.emphasizedOff();

    Printer.left();
    Printer.line("Fecha: " + this.fecha);
    Printer.br();

    Printer.center();
    Printer.line("------------------------------------------------");
    Printer.line("RECARGA ELECTRONICA");
    Printer.line("------------------------------------------------");
    Printer.br();

    Printer.left();
    Printer.write("Recarga".padEnd(18));
    Printer.write(this.company.padEnd(12));
    Printer.br();
    Printer.write("Telefono".padEnd(18));
    Printer.write(this.telefono.padEnd(12));
    Printer.br();
    Printer.write("Monto".padEnd(18));
    Printer.write("$"+this.monto.padEnd(12));
    Printer.br();
    Printer.write("ID".padEnd(18));
    Printer.write(this.idTransaction.padEnd(12));
    Printer.br();

    Printer.center();
    Printer.line("------------------------------------------------");
    Printer.br();
    Printer.line("Recarga realizada!");
    Printer.br(5);

    Printer.print();
};