let PrinterCuadre = function (data) {
    "use strict";

    this.data = data;
}

PrinterCuadre.prototype.print = function() {
    Printer.reset();

    Printer.fontA();
    Printer.center();

    Printer.emphasized();
    Printer.underline();
    Printer.line(Empresa.getNombre());
    Printer.underlineOff();
    Printer.emphasizedOff();

    Printer.line(Empresa.getEslogan());
    Printer.line("Tel: " + Empresa.getTelefono());
    Printer.line("Fecha: " + this.data.fecha);
    Printer.line("Vendedor: " + Vendedor.getNombre());
    Printer.br();
    Printer.line("--------------------------------");
    Printer.br();

    // pago premios
    if (this.data.pagos.length > 0) {
        Printer.underline();
        Printer.line("Pagos de Premios");
        Printer.underlineOff();
        this.data.pagos.forEach(function (row) {console.log(row);
            Printer.write(row.fecha.padEnd(20));
            Printer.write(row.monto.padStart(10));
            Printer.br();
        });
        Printer.br();
        Printer.line("------------------------------------------------");
        Printer.br();
    }

    // resumen
    Printer.underline();
    Printer.line("Resumen");
    Printer.underlineOff();

    Printer.write("Ventas:".padEnd(20)).write(this.data.ventas.padStart(10)).br();
    Printer.write("Comision:".padEnd(20)).write(this.data.comision.padStart(10)).br();
    Printer.write("Premios:".padEnd(20)).write(this.data.premios.padStart(10)).br();
    Printer.write("Resultado:".padEnd(20)).write(this.data.resultado.padStart(10)).br();

    let is_sub = false;
    if (this.data.pagado > 0) {
        is_sub = true;
        Printer.write("Pagos Premios:".padEnd(20)).write(this.data.pagado.padStart(10)).br();
        Printer.bold();
        Printer.write("Sub Total:".padEnd(20)).write(this.data.subtotal.padStart(10)).br();
        Printer.boldOff();
    }

    if (this.data.saldado) {
        Printer.write("Monto Saldado:".padEnd(20)).write(this.data.saldado.padStart(10)).br();
        Printer.bold();
        Printer.write((is_sub?"Total:":"Sub Total:").padEnd(20)).write(this.data.total.padStart(10)).br();
        Printer.boldOff();
    }

    Printer.write("Deuda Anterior:".padEnd(20)).write(this.data.deuda.padStart(10)).br();

    if (this.data.recibos) {
        Printer.write("Pagos Realizados:".padEnd(20)).write(this.data.recibos.padStart(10)).br();
    }

    Printer.bold();
    Printer.write("Balance:".padEnd(20)).write(this.data.balance.padStart(10)).br();
    Printer.boldOff();

    // recargas
    if (parseInt(this.data.recargas) > 0) {
        Printer.br();
        Printer.bold();
        Printer.line("Recargas");
        Printer.boldOff();

        Printer.write("Recargas:".padEnd(20)).write(this.data.recargas.toString().padStart(10)).br();
        Printer.write("Recargas Comision:".padEnd(20)).write(this.data.recargas_comision.toString().padStart(10)).br();

        Printer.bold();
        Printer.write("TOTAL A PAGAR:".padEnd(20)).write(this.data.total_total.toString().padStart(10)).br();
        Printer.boldOff();
    }

    Printer.br(5);

    Printer.print();
}