let Loterias = function() {
    "use strict";

    // lista de loterias con indice "codigo"
    const list = {};

    let init = function (data) { console.log("Loterias.init()");
        data.forEach(function (row) {
            list[row['id']] = new Loteria(row.id, row.formato, row.codigo, row.abreviado, row.nombre, row.horario, row.tipo);
        });
    }

    let get = function(id) {
        return list[id];
    }

    /**
     * Devuelve una loteria
     * @param codigo
     */
    let getFromCode = function(codigo) { console.log("Loterias.getFromCode():" + codigo);
        codigo = filter.int(codigo);
        let loteria = null;
        Object.values(list).forEach(function (lot) {
            if (lot.getCodigo() === codigo) {
                loteria = lot;
            }
        });

        return loteria;
    }

    /**
     * Devuelve una loteria
     * @param abreviado
     */
    let getFromAbreviado = function(abreviado) { console.log("Loterias.getFromAbreviado():" + abreviado);
        let loteria = null;
        Object.values(list).forEach(function (lot) {
            if (lot.getAbreviado() === abreviado) {
                loteria = lot;
            }
        });

        return loteria;
    }

    /**
     * Devuelve un listado de loterias
     * @param abreviados
     */
    let getFromAbreviados = function(abreviados) {
        let list = [];

        let lot;
        let r = abreviados.split(' ');
        r.forEach(function (abreviado) {
            lot = getFromAbreviado(abreviado);
            if (lot) {
                list.push(lot);
            }
        });

        return list;
    }

    let getFromCodigos = function(codigos) {
        let list = [];

        let lot;
        let r = codigos.split('');
        for (let i=0; i<r.length; i++) {
            lot = getFromCode(r[i]);
            if (lot != null) {
                list.push(lot);
            }
        }

        return list;
    }

    let getFirstFromAbreviados = function(abreviados) {
        let r = abreviados.split(' ');
        if (r.length == 0) {
            return null;
        }

        return getFromAbreviado(r[0]);
    }

    let getFirstFromCodigos = function(codigos) {
        let r = codigos.split('');
        if (r.length == 0) {
            return null;
        }

        return getFromCode(r[0]);
    }


    /**
     * Checa si una loteria existe
     */
    let contains = function(id) {
        return list[id] ? true: false;
    }

    /**
     * Devuelve listado de loterias en un array
     */
    let getList = function() {
        return Object.values(list);
    }

    let getIdsFromAbreviados = function(abreviados) {
        let r = abreviados.split(" ");
        if (r.length == 0) {
            return null;
        }

        let loteria;
        let result = [];
        for (let i=0; i<r.length; i++) {
            loteria = getFromAbreviado(r[i]);
            if (loteria) {
                result.push(loteria.getId());
            }
        }

        return result.join(',');
    }

    let getIdsFromCodigos = function(codigos) {
        let r = codigos.split('');
        if (r.length == 0) {
            return null;
        }

        let loteria;
        let result = [];
        for (let i=0; i<r.length; i++) {
            loteria = getFromCode(r[i]);
            if (loteria) {
                result.push(loteria.getId());
            }
        }

        return result.join(',');
    }

    let getAbreviadosFromCodigos = function(codigos) {
        let r = codigos.split('');
        if (r.length == 0) {
            return null;
        }

        let loteria;
        let result = [];
        for (let i=0; i<r.length; i++) {
            loteria = getFromCode(r[i]);
            if (loteria) {
                result.push(loteria.getAbreviado());
            }

            if (result.length >= 4) { break; }
        }

        return result.join(' ');
    }

    let getCodigosFromAbreviados = function(abreviados) {
        let r = abreviados.split(' ');
        if (r.length == 0) {
            return null;
        }

        let loteria;
        let result = [];
        for (let i=0; i<r.length; i++) {
            loteria = getFromAbreviado(r[i]);
            if (loteria) {
                result.push(loteria.getCodigo());
            }
        }

        return result.join('');
    }

    /**
     * Actualiza los datos de una loteria, o la crea  si no existe
     */
    let touch = function (data) {
        data = data['data'];
        list[data['id']] = new Loteria(data.id, data.formato, data.codigo, data.abreviado, data.nombre, data.horario, data.tipo);


    }

    return {
        init: init,
        get: get,
        getFromCode: getFromCode,
        getFromAbreviado: getFromAbreviado,
        getFromAbreviados: getFromAbreviados,
        getFromCodigos: getFromCodigos,
        getFirstFromAbreviados: getFirstFromAbreviados,
        getFirstFromCodigos: getFirstFromCodigos,
        getIdsFromAbreviados: getIdsFromAbreviados,
        getIdsFromCodigos: getIdsFromCodigos,
        getAbreviadosFromCodigos: getAbreviadosFromCodigos,
        getCodigosFromAbreviados: getCodigosFromAbreviados,
        contains: contains,
        getList: getList,
        touch: touch,

        FORMATO_DOMINICANA: "dominicana",
        FORMATO_AMERICANA: "americana",
        FORMATO_CASH3: "cash3",
        FORMATO_PLAY4: "play4",
        FORMATO_BORLETTE: "borlette",
    }
}();