"use strict";

function Loteria(id, formato, codigo, abreviado, nombre, horario, tipo) {
    this.id = id;
    this.formato = formato;
    this.codigo = codigo;
    this.abreviado = abreviado;
    this.nombre = nombre;
    this.horario = horario;
    this.tipo = tipo;
}

Loteria.prototype.setCodigo = function(codigo) {
    this.codigo = codigo;
}

Loteria.prototype.setAbreviado = function(abreviado) {
    this.abreviado = abreviado;
}

Loteria.prototype.setNombre = function(nombre) {
    this.nombre = nombre;
}

Loteria.prototype.getId = function() {
    return this.id;
}

Loteria.prototype.getFormato = function () {
    return this.formato;
}


Loteria.prototype.getTipo = function () {
    return this.tipo;
}

Loteria.prototype.getNombre = function() {
    return this.nombre;
}

Loteria.prototype.getAbreviado = function() {
    return this.abreviado;
}

Loteria.prototype.getCodigo = function() {
    return this.codigo;
}

Loteria.prototype.getHorario = function() {
    return this.horario.length==5 ? this.horario : "0"+this.horario;
}

Loteria.prototype.isDominicana = function() {
    return Loterias.FORMATO_DOMINICANA === this.formato;
}

Loteria.prototype.isAmericana = function() {
    return Loterias.FORMATO_AMERICANA === this.formato;
}

Loteria.prototype.isCash3 = function() {
    return Loterias.FORMATO_CASH3 === this.formato;
}

Loteria.prototype.isPlay4 = function() {
    return Loterias.FORMATO_PLAY4 === this.formato;
}

Loteria.prototype.isBorlette = function() {
    return Loterias.FORMATO_BORLETTE === this.formato;
}

Loteria.prototype.isOpen = function() {
    let hora_actual = Time.getHHMM();
    let hora_cierre = this.getHorario();
    //console.log(this.abreviado + " actual:"+hora_actual+ " cierre:"+hora_cierre+" abierta:"+(hora_actual < hora_cierre));
    if (hora_actual < hora_cierre) {
        return true;
    }

    return false;
}