"use strict";

let Jugada  = function (numero, loteria, valor, jugstr) {
    this.numero = numero;
    this.loteria = loteria;
    this.valor = filter.float(valor);
    this.jugstr = jugstr;

    /*// maximo 4 loterias por jugada
    if (this.countLoterias() > 4) {
        this.loteria = StringUtils.join(Arrays.copyOfRange(loteria.split(","), 0, 4), ",");
    }*/
}

Jugada.prototype.setNumero = function(numero) {
    this.numero = numero;
}

Jugada.prototype.setLoteria = function(loteria) {
    this.loteria = loteria+"";
}

Jugada.prototype.setValor = function(valor) {
    this.valor = filter.float(valor);
}

Jugada.prototype.setJugstr = function(jugstr) {
    this.jugstr = jugstr;
}

Jugada.prototype.getNumero = function(){
    return this.numero;
}

/**
 * Devuelve el numero jugado, separado por "-" cuando es pale o tripleta
 */
Jugada.prototype.getNumero2 = function() {
    let loteriaFirst = Loterias.get(this.getLoteriaOne());
    if (loteriaFirst.isDominicana()) {
        return this.numero.match(/.{2}/g).join('-');
    }
    else {
        return this.numero;
    }
}

/**
 * Devuelve el codigo de la loteria
 */
Jugada.prototype.getLoteria = function(){
    return this.loteria;
}

/**
 * Devuelve los codigos de la loterias en un array
 */
Jugada.prototype.getLoterias = function(){
    return this.loteria.split(',');
}

/**
 * Devuelve la primera loteria (a veces hay varias)
 */
Jugada.prototype.getLoteriaOne = function() {
    let str = this.loteria+"";
    return str.split(',')[0];
}

/**
 * Cuenta el total de loterias presentes en esta jugada
 */
Jugada.prototype.countLoterias = function(){
    let str = this.loteria+"";
    return str.split(',').length;
}

/**
 * Devuelve los nombres abreviados de las loterias, separados por espacio (" ")
 */
Jugada.prototype.getLoteriasAbreviado = function() {
    var loterias_res = [];
    var loterias = this.loteria.toString().split(',');

    loterias.forEach(function (codigo) {
        loterias_res.push(Loterias.get(codigo).getAbreviado());
    });

    return loterias_res.join(' ');
}

Jugada.prototype.getValor = function() {
    return this.valor;
}

Jugada.prototype.getValor2 = function() {
    if (!this.valor) {
        return 0;
    }

    if (this.jugstr == Jugadas.SUPER_PALE) {
        return this.valor;
    }
    else {
        return this.valor * this.countLoterias();
    }
}

Jugada.prototype.getJugstr = function(){
    return this.jugstr;
}