/*!
* phone-codes/phone-ca.js
* https://github.com/RobinHerbots/Inputmask
* Copyright (c) 2010 - 2017 Robin Herbots
* US Database by Yevgen Sukharenko
* Licensed under the MIT license (http://www.opensource.org/licenses/mit-license.php)
* Version: 3.3.7
*/

!function(factory) {
    "function" == typeof define && define.amd ? define([ "../inputmask" ], factory) : "object" == typeof exports ? module.exports = factory(require("../inputmask")) : factory(window.Inputmask);
}(function(Inputmask) {
    return Inputmask.extendAliases({
        phoneus: {
            alias: "abstractphone",
            countrycode: "1",
            phoneCodes: [
                {
                    "mask": "+1(201)200-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)202-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)203-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Ymax Communications Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)204-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Eureka Telecom DBA Eureka Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)205-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)206-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)207-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)208-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)209-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)210-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)212-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)213-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)214-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)215-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Bayonne",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)216-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)217-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)218-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)219-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)220-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)221-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)222-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)223-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)224-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Leonia",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)225-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)226-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)227-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Englewood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)228-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)229-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)230-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Succasunna",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)231-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)232-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)233-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Cliffside Park",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)234-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)235-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "General Communications & Electronics Corp.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)236-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)237-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "American Messaging (am)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)238-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)239-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)240-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)241-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)242-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Leonia",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)243-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Bayonne",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)244-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Dumont",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)245-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)246-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Kearny",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)247-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Caldwell",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)248-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)249-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Fair Lawn",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)250-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)251-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ridgewood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)252-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)253-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)254-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)255-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)256-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)257-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hasbrouck Heights",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)258-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)259-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)261-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)262-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)263-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Westwood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)264-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)265-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)266-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)267-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)268-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)269-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Wyckoff",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)270-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)271-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)272-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)273-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)274-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)275-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)276-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Aquis Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)277-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Aquis Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)278-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Dumont",
                    "operator": "Aquis Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)279-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Kearny",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)280-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Fair Lawn",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)281-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)282-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Cliffside Park",
                    "operator": "Time Warner Cb Info Sv (nj) DBA Time Warnercb Nj",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)283-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Kearny",
                    "operator": "Telcove Investment",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)284-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)285-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Ctc Communications Corp., DBA Ct Comm Corp",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)286-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)287-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teaneck",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)288-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hasbrouck Heights",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)289-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)290-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)291-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)292-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Mci Worldcom Communications, Nj",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)293-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Telcove Investment",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)294-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)295-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)296-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)297-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Closter",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)298-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hasbrouck Heights",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)299-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Kearny",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)300-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)301-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ridgewood",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)302-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Leonia",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)303-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)304-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teaneck",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)305-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)306-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)307-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Park Ridge",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)308-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)309-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)310-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)312-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Maywood",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)313-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Cliffside Park",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)314-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)315-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)316-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)317-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Succasunna",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)318-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)319-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)320-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)321-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Fair Lawn",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)322-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)323-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)324-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)325-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)326-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Park Ridge",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)327-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)328-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)329-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)330-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)331-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Mahwah",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)332-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)333-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)334-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Global Crossing Local Services-nj",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)335-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)336-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)337-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oakland",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)338-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Dumont",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)339-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Bayonne",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)340-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Maywood",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)341-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)342-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)343-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)344-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teterboro",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)345-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ridgewood",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)346-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Leonia",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)347-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teaneck",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)348-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)349-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)350-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)351-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Bandwidth.com Clec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)352-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)353-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Secaucus",
                    "operator": "Allegiance Telecom Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)354-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Bayonne",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)355-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "Monmouth Telephone & Telegraph Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)356-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)357-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teaneck",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)358-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Westwood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)359-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Telcove Investment",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)360-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Telcove Investment",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)361-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Telcove Investment",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)362-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)363-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Leonia",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)364-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)365-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hasbrouck Heights",
                    "operator": "Monmouth Telephone & Telegraph Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)366-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "Time Warner Cb Info Sv (nj) DBA Time Warnercb Nj",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)367-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Closter",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)368-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)369-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)370-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)371-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teaneck",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)372-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)373-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)374-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Dumont",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)375-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hasbrouck Heights",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)376-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)377-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)378-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)379-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teaneck",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)380-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Peerless Network Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)381-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)382-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)383-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Westwood",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)384-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Dumont",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)385-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Dumont",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)386-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)387-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Dumont",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)388-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)389-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ridgewood",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)390-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)391-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Park Ridge",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)392-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)393-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hasbrouck Heights",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)394-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)395-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)396-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Caldwell",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)397-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)398-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Fair Lawn",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)399-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Englewood",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)400-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)401-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)402-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Cliffside Park",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)403-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Mci Worldcom Communications, Nj",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)404-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)405-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oakland",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)406-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)407-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)408-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Englewood",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)409-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)410-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Fair Lawn",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)412-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)413-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)414-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Fair Lawn",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)415-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)416-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)417-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)418-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)419-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)420-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)421-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)422-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)423-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)424-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)425-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Wyckoff",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)426-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hasbrouck Heights",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)427-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)428-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Kearny",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)429-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Leonia",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)430-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)431-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "Local Access LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)432-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)433-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)434-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)435-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)436-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Bayonne",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)437-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Bayonne",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)438-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)439-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Dumont",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)440-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)441-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)442-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)443-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)444-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ridgewood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)445-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ridgewood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)446-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)447-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ridgewood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)448-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)449-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)450-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)451-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)452-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Caldwell",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)453-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)454-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)455-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)456-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)457-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)458-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Global Crossing Local Services-nj",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)459-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)460-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)461-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Leonia",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)462-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hasbrouck Heights",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)463-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)464-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Peerless Network Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)465-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oakland",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)466-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "",
                    "operator": "Telergy Joint Venture",
                    "desc": "Unknown"
                },
                {
                    "mask": "+1(201)467-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Kearny",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)468-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Fair Lawn",
                    "operator": "Bandwidth.com Clec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)469-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)470-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)471-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Global Crossing Local Services-nj",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)472-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Monmouth Telephone & Telegraph Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)473-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Secaucus",
                    "operator": "Allegiance Telecom Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)474-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)475-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Fair Lawn",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)476-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Park Ridge",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)477-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)478-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)479-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Peerless Network Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)481-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)482-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Leonia",
                    "operator": "Telcove Investment",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)483-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)484-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Monmouth Telephone & Telegraph Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)485-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)486-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)487-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)488-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)489-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)490-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)491-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)492-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)493-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ridgewood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)494-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)495-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)496-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Cliffside Pk",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)497-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)498-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)499-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)500-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Englewood",
                    "operator": "Telcove Investment",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)501-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Dumont",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)502-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)503-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Englewood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)504-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Cooperative Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)505-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Park Ridge",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)506-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)507-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)508-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)509-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Fair Lawn",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)510-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Englewood",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)512-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)513-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)514-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Telcove Investment",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)515-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Bayonne",
                    "operator": "Telcove Investment",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)516-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)517-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)518-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)519-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)520-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Mci Worldcom Communications, Nj",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)521-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)522-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)523-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Conversent Communications Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)524-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)525-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)526-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)527-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)528-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Mci Worldcom Communications, Nj",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)529-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)530-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teaneck",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)531-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)532-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)533-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)534-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Westwood",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)535-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)536-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)537-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)538-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)539-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)540-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Wyckoff",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)541-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Englewood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)542-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)543-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)544-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)545-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Cliffside Park",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)546-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)547-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)548-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Leonia",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)549-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)552-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)553-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)556-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)557-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)558-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)559-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)560-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Wyckoff",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)561-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)562-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Monmouth Telephone & Telegraph Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)563-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)564-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Closter",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)565-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Bandwidth.com Clec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)566-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Fair Lawn",
                    "operator": "Telcove Investment",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)567-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Englewood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)568-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Englewood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)569-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Englewood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)570-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)571-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Park Ridge",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)572-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)573-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Park Ridge",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)574-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)575-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Weehawken",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)576-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)577-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Tw Telecom Of New Jersey Lp",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)578-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teaneck",
                    "operator": "Monmouth Telephone & Telegraph Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)579-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Mahwah",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)580-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)581-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oakland",
                    "operator": "Peerless Network Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)582-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)583-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)584-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Peerless Network Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)585-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Leonia",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)586-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Englewood",
                    "operator": "Peerless Network Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)587-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)588-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Closter",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)589-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)590-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)591-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)592-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Leonia",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)593-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)594-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Westwood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)595-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)596-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)597-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)598-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Cliffside Pk",
                    "operator": "Metro PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)599-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)600-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)601-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)602-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)603-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Secaucus",
                    "operator": "Allegiance Telecom Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)604-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Allegiance Telecom Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)605-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Allegiance Telecom Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)606-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Allegiance Telecom Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)607-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)608-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Englewood",
                    "operator": "Allegiance Telecom Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)610-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)612-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ridgewood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)613-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Allegiance Telecom Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)614-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Big River Telephone Company - MO",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)615-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)616-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)617-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)618-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)619-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)620-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Bayonne",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)621-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Secaucus",
                    "operator": "Allegiance Telecom Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)622-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Kearny",
                    "operator": "Allegiance Telecom Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)623-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Allegiance Telecom Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)624-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Broadview Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)625-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Secaucus",
                    "operator": "Allegiance Telecom Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)626-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)627-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Englewood",
                    "operator": "Monmouth Telephone & Telegraph Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)628-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Kearny",
                    "operator": "Global Crossing Local Services-nj",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)629-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Superior Communications Technology Corp.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)630-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)631-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)632-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Secaucus",
                    "operator": "Allegiance Telecom Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)633-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)634-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)635-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)636-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Atx Telecommunications Services, Ltd",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)637-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)638-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)639-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ridgewood",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)640-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Metro PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)641-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)642-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Mahwah",
                    "operator": "Allegiance Telecom Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)643-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Allegiance Telecom Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)644-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oakland",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)645-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Global Crossing Local Services-nj",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)646-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)647-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)648-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Dumont",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)649-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)650-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)651-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oakland",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)652-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ridgewood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)653-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)654-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)655-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Conversent Communications Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)656-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)657-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)658-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Cliffside Park",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)659-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)660-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)661-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)662-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)663-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)664-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Westwood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)665-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)666-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Westwood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)667-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Kearny",
                    "operator": "Metro PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)668-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)669-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)670-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ridgewood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)671-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)672-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)673-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Cliffside Park",
                    "operator": "Telcove Investment",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)674-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)675-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)676-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Leonia",
                    "operator": "Monmouth Telephone & Telegraph Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)677-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oakland",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)678-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)679-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)680-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)681-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)682-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Cliffside Pk",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)683-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)684-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)685-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)686-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)687-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Metro PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)688-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Bayonne",
                    "operator": "Monmouth Telephone & Telegraph Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)689-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ridgewood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)690-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Park Ridge",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)691-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)692-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teaneck",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)693-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Fair Lawn",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)694-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)695-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)696-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)697-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)698-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)699-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Cliffside Park",
                    "operator": "Monmouth Telephone & Telegraph Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)701-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ridgewood",
                    "operator": "Neutral Tandem-new Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)702-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Kearny",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)703-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Fair Lawn",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)704-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Caldwell",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)705-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Eureka Telecom DBA Eureka Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)706-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)707-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)708-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)709-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)710-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)712-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)713-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Caldwell",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)714-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)715-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)716-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)718-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "American Messaging (am)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)719-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Kearny",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)720-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Leonia",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)721-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Comcast Business Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)722-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Westwood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)723-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)724-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Cliffside Park",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)725-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)726-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Kearny",
                    "operator": "Monmouth Telephone & Telegraph Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)727-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hasbrouck Heights",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)728-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)729-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)730-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Park Ridge",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)731-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Global Crossing Local Services-nj",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)733-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Mahwah",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)734-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Allegiance Telecom Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)735-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)736-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)737-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Metro PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)738-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)739-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)740-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Global Crossing Local Services-nj",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)741-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)742-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Secaucus",
                    "operator": "Allegiance Telecom Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)743-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Mci Worldcom Communications, Nj",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)744-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Broadvox-clec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)745-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)746-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Park Ridge",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)747-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)748-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)749-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)750-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Closter",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)751-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Global Crossing Local Services-nj",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)752-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)753-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Network Billing Systems, Lc",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)754-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Global Crossing Local Services-nj",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)755-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)756-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Advantage Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)757-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Passaic",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)758-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)759-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)760-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)761-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)762-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Maywood",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)763-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Warwick Valley Telephone Company",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)764-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teaneck",
                    "operator": "Cooperative Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)765-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Global Crossing Local Services-nj",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)766-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)767-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Closter",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)768-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Closter",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)769-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Advantage Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)770-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)771-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Dumont",
                    "operator": "Ctc Communications Corp., DBA Ct Comm Corp",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)772-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Kearny",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)773-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Fair Lawn",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)774-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)775-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Park Ridge",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)776-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)777-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)778-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Mahwah",
                    "operator": "Telcove Investment",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)779-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)780-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teterboro",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)781-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Westwood",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)782-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Park Ridge",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)783-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Monmouth Telephone & Telegraph Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)784-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Closter",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)785-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)786-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Xo New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)787-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)788-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)789-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Dial-a-beeper",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)790-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Wyckoff",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)791-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Fair Lawn",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)792-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)793-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Mci Worldcom Communications, Nj",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)794-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Fair Lawn",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)795-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)796-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Fair Lawn",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)797-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Fair Lawn",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)798-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)799-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Park Ridge",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)800-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)801-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teaneck",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)802-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Park Ridge",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)803-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)804-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)805-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)806-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)807-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)808-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teaneck",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)809-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)810-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Dial-a-beeper",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)812-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Wyckoff",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)813-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Superior Communications Technology Corp.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)814-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)815-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Fair Lawn",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)816-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Englewood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)817-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teaneck",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)818-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)819-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)820-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)821-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Cooperative Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)822-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Park Ridge",
                    "operator": "Allegiance Telecom Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)823-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Bayonne",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)824-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Wyckoff",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)825-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)826-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)827-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)828-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)829-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Westwood",
                    "operator": "Allegiance Telecom Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)830-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)831-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)832-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)833-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teaneck",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)834-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Monmouth Telephone & Telegraph Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)835-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Fair Lawn",
                    "operator": "Monmouth Telephone & Telegraph Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)836-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teaneck",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)837-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teaneck",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)838-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)839-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Global Crossing Local Services-nj",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)840-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Cliffside Park",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)841-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Succasunna",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)842-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)843-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)844-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Bayonne",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)845-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)846-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)847-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Wyckoff",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)848-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Wyckoff",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)849-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)850-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)851-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)852-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)853-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Cooperative Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)854-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)855-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Ymax Communications Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)857-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ridgewood",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)858-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Bayonne",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)859-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)860-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)861-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)862-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teaneck",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)863-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)864-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)865-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)866-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)867-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)868-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)869-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)870-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Bandwidth.com Clec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)871-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Englewood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)872-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)873-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Fair Lawn",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)874-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Succasunna",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)875-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Broadvox-clec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)876-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)877-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Cliffside Pk",
                    "operator": "Metro PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)878-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Mci Worldcom Communications, Nj",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)879-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ridgewood",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)880-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)881-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)882-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ridgewood",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)883-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)884-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)885-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Barr Tell Usa",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)886-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Leonia",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)887-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)888-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)889-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Kearny",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)890-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hasbrouck Heights",
                    "operator": "Telcove Investment",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)891-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Wyckoff",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)892-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teterboro",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)893-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)894-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Englewood",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)895-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oakland",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)896-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)897-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oakland",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)898-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Local Access LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)899-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Closter",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)901-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)902-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)903-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Wyckoff",
                    "operator": "Broadvox-clec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)904-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Wyckoff",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)905-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Closter",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)906-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)907-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teaneck",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)909-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)910-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)912-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)913-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)914-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)915-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)916-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)917-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Cliffside Park",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)918-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)919-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)920-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)921-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)922-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "",
                    "operator": "Geotek Communications",
                    "desc": "Unknown"
                },
                {
                    "mask": "+1(201)923-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)924-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Morristown",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)925-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ridgewood",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)926-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)927-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)928-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teaneck",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)929-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Dial-a-beeper",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)930-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Park Ridge",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)931-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)932-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Bayonne",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)933-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)934-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)935-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)936-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)937-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)938-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)939-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)940-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)941-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Cliffside Park",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)942-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)943-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Cliffside Park",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)944-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Leonia",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)945-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Cliffside Park",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)946-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)947-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Leonia",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)948-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Kearny",
                    "operator": "Mosaic Networx LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)949-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rochelle Park",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)951-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)952-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hasbrouck Heights",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)953-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Caldwell",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)954-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Caldwell",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)955-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Kearny",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)956-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Fair Lawn",
                    "operator": "Conversent Communications Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)957-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Newark",
                    "operator": "Bandwidth.com Clec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)960-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)961-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Allegiance Telecom Of New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)962-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)963-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)964-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)965-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)966-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)967-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)968-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)969-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Leonia",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)970-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)971-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "",
                    "operator": "Eagle Communications",
                    "desc": "Unknown"
                },
                {
                    "mask": "+1(201)972-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ridgewood",
                    "operator": "Monmouth Telephone & Telegraph Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)974-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Union City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)975-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Teleport Communications Group - New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)977-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Weehawken",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)978-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)979-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)980-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Rutherford",
                    "operator": "American Messaging (am)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)981-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)982-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)983-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)984-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Comcast Business Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)985-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)986-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)987-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Oradell",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)988-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)989-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Wyckoff",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)991-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Kearny",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)992-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Teaneck",
                    "operator": "Broadview Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)993-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Jersey City",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(201)994-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)995-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Ramsey",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)996-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Hackensack",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)997-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Kearny",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(201)998-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "NJ",
                    "city": "Kearny",
                    "operator": "Verizon New Jersey",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)200-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Bandwidth.com Clec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)201-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)202-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Darien",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)204-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Guilford",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)205-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)206-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)207-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)208-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Branford",
                    "operator": "Comcast Phone Of Connecticut",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)209-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)210-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wilton",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)212-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)213-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)214-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)215-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)216-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Westport",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)217-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)218-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)219-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)220-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Trumbull",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)221-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Westport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)222-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Westport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)223-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)224-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)225-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Huntington",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)226-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Westport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)227-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Westport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)228-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)229-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)230-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)231-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Derby",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)232-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)233-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)234-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)235-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)236-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)237-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)238-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)239-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)240-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)241-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)242-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Huntington",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)243-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)244-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Ridgefield",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)245-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Madison",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)246-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)247-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)248-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)249-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)250-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Cheshire",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)251-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)252-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)253-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)254-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Fairfield",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)255-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Fairfield",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)256-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Fairfield",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)257-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)258-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)259-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Fairfield",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)260-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)261-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Trumbull",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)262-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Southbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)263-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Woodbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)264-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Southbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)265-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wallingford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)266-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Woodbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)267-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Southbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)268-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Trumbull",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)269-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wallingford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)270-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Newtown",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)271-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Cheshire",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)272-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Cheshire",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)273-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)274-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)275-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)276-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)277-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Old Greenwich",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)278-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Derby",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)279-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)280-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Darien",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)281-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)282-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)283-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Milford",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)284-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wallingford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)285-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)286-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Conversent Communications Of Connecticut",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)287-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)288-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)289-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)290-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)291-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Westport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)292-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Fairfield",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)293-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)294-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wallingford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)295-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)296-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)297-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)298-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)299-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)300-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)301-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Milford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)302-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Teleport Communications Group - NY",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)303-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wallingford",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)304-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Newtown",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)305-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Derby",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)306-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Milford",
                    "operator": "Choice One Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)307-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Fairfield",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)308-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Derby",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)309-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)310-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Canaan",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)312-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)313-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)314-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)315-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Branford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)316-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)317-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)318-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Madison",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)319-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Fairfield",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)320-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Darien",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)321-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)322-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)323-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)324-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)325-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)326-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)327-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)328-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)329-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)330-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)331-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)332-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)333-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)334-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)335-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)336-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)337-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)338-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)339-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)340-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)341-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Westport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)342-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)343-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Derby",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)344-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Old Greenwich",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)345-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)346-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)347-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)348-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)349-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Westport",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)350-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Madison",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)351-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)352-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)353-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)354-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)355-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)356-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)357-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)358-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)359-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)360-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Metro PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)361-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)362-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)363-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)364-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Newtown",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)365-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)366-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)367-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)368-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)369-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Old Greenwich",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)370-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "American Messaging (am)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)371-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)372-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)373-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)374-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)375-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)376-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)377-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)378-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)379-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)380-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)381-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)382-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)383-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)384-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)385-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)386-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)387-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)388-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)389-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)390-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)391-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)392-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)393-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)394-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)395-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)396-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)397-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)398-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)399-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)400-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Trumbull",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)401-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)402-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Huntington",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)403-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Ridgefield",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)404-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)405-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Woodbury",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)406-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)407-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)408-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Redding",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)409-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Old Greenwich",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)410-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)412-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "American Messaging (am)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)413-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Paetec Communications - NY",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)414-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)415-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)416-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)417-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)418-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Fairfield",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)419-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)420-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)421-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Madison",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)422-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Verizon New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)423-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wilton",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)424-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)425-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)426-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Newtown",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)427-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)428-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)429-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)430-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)431-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Ridgefield",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)432-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)433-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Branford",
                    "operator": "Comcast Phone Of Connecticut",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)434-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)435-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)436-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)437-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)438-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Ridgefield",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)439-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Cheshire",
                    "operator": "Cox Connecticut Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)440-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "Cox Connecticut Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)441-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wolcott",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)442-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Canaan",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)443-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)444-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)445-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Trumbull",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)446-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Derby",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)447-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Huntington",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)448-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)449-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)450-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)451-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Westport",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)452-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Trumbull",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)453-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Guilford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)454-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Westport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)455-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)456-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)457-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Guilford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)458-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Guilford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)459-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Trumbull",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)460-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)461-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)462-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)463-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Seymour",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)464-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)465-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)466-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)467-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)468-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)469-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)470-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)471-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Unknown"
                },
                {
                    "mask": "+1(203)472-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Unknown"
                },
                {
                    "mask": "+1(203)473-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Unknown"
                },
                {
                    "mask": "+1(203)474-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Unknown"
                },
                {
                    "mask": "+1(203)476-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Unknown"
                },
                {
                    "mask": "+1(203)477-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)478-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Unknown"
                },
                {
                    "mask": "+1(203)479-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)480-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Fairfield",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)481-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Branford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)482-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)483-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Branford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)484-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Northford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)485-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)486-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Southbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)487-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)488-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Branford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)489-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)490-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Naugatuck",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)491-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Newtown",
                    "operator": "Bandwidth.com Clec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)492-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)493-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Redding",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)494-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)495-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)496-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)497-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)498-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)499-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)500-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)501-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)502-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)503-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)504-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Ctc Communications Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)505-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)506-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)507-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)508-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Ctc Communications Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)509-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)510-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)512-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)513-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)514-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)515-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)516-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Derby",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)517-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)518-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)519-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)520-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)521-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)522-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)523-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)524-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)525-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)526-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)527-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)528-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)529-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wilton",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)530-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)531-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Verizon New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)532-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Verizon New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)533-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Guilford",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)534-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)535-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Comcast Phone Of Connecticut",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)536-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)537-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)538-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Huntington",
                    "operator": "Choice One Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)539-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)540-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)541-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)542-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)543-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)544-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Redding",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)545-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)546-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)547-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Global Naps",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)548-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)549-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Choice One Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)550-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)551-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)552-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Verizon New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)553-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)554-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)556-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)557-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Westport",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)558-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)559-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Darien",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)560-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)561-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)562-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)563-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wilton",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)564-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)565-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)566-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)567-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Huntington",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)568-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)569-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)570-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)571-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Westport",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)572-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)573-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)574-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)575-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)576-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)577-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)578-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)579-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)580-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Peerless Network Of Connecticut",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)581-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)582-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)583-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)584-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)585-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)586-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Woodbury",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)587-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Redding",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)588-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)589-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)590-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Trumbull",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)591-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)592-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)593-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)594-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Canaan",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)595-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)596-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)597-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)598-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)599-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)600-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "Metro PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)601-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Trumbull",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)602-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)603-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)604-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)605-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)606-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)607-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)608-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)609-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)610-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Conversent Communications Of Connecticut",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)612-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)613-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)614-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)615-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)616-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)617-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)618-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Verizon New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)619-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)620-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Darien",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)621-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Darien",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)622-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Verizon New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)623-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)624-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)625-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Verizon New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)626-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)627-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)628-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)629-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Verizon New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)630-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)631-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)632-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Naugatuck",
                    "operator": "Choice One Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)633-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wolcott",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)634-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)635-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)636-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Darien",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)637-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Old Greenwich",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)638-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Trumbull",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)639-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)640-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)641-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)642-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)643-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Branford",
                    "operator": "Choice One Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)644-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)645-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)646-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Branford",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)647-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Milford",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)648-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)649-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Cheshire",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)650-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)651-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Cheshire",
                    "operator": "Choice One Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)652-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)653-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)654-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)655-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Darien",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)656-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Darien",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)657-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "American Messaging (am)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)658-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)659-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Fairfield",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)660-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)661-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Verizon New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)662-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Darien",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)663-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)664-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Redding",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)665-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)666-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)667-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)668-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)669-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Darien",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)670-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "American Messaging (am)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)671-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)672-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)673-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)674-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)675-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)676-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)677-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wallingford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)678-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wallingford",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)679-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wallingford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)680-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)681-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Verizon New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)682-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)683-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)684-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Metro PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)685-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)686-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)687-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)688-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)689-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)690-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)691-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)692-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Fairfield",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)693-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Milford",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)694-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)695-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)696-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)697-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wallingford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)698-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Old Greenwich",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)699-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Cheshire",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)701-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)702-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)703-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)704-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wolcott",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)705-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)706-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Ctc Communications Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)707-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)708-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)709-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)710-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)712-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Huntington",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)713-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Milford",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)714-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Naugatuck",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)715-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)716-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)717-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)718-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Cheshire",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)719-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)720-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Naugatuck",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)721-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)722-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)723-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Naugatuck",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)724-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Choice One Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)725-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Cox Connecticut Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)726-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)727-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)728-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)729-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Naugatuck",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)730-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)731-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)732-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Ansonia",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)733-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)734-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Ansonia",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)735-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Ansonia",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)736-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Ansonia",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)737-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)738-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Guilford",
                    "operator": "Choice One Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)739-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)740-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)741-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wallingford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)742-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)743-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)744-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)745-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Sbc Internet Services",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)746-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)747-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)748-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)749-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)750-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)751-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Ansonia",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)752-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)753-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)754-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)755-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)756-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)757-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)758-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)759-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)760-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Peerless Network Of Connecticut",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)761-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wilton",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)762-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wilton",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)763-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Fairfield",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)764-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)765-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)766-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "American Messaging (am)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)767-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)768-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)769-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Verizon New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)770-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)771-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)772-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)773-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)774-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wallingford",
                    "operator": "Choice One Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)775-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)776-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)777-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)778-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)779-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Madison",
                    "operator": "Choice One Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)780-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Peerless Network Of Connecticut",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)781-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)782-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)783-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Milford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)784-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)785-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)786-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)787-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)788-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)789-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)790-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)791-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)792-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)793-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wallingford",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)794-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)795-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)796-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)797-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)798-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)799-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)800-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)801-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Canaan",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)802-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Metro PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)803-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)804-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)805-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)806-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Cheshire",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)807-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)808-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)809-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)810-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)812-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)813-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Teleport Communications Group - NY",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)814-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)815-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)816-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Trumbull",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)817-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)818-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)819-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)820-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)821-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)822-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)823-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Comcast Phone Of Connecticut",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)824-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)825-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)826-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)827-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Old Greenwich",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)828-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Seymour",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)829-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)830-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)831-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)832-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)833-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)834-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wilton",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)835-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)836-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)837-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)838-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)839-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)840-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)841-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Choice One Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)842-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)843-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)844-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Fairfield",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)845-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)846-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)847-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)848-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Conversent Communications Of Connecticut",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)849-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)850-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Metro PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)851-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)852-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)853-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)854-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)855-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)856-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)857-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)858-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)859-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)861-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Verizon New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)862-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Verizon New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)863-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Verizon New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)864-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)865-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)866-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)867-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)868-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)869-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Verizon New York",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)870-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)871-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Branford",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)872-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)873-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)874-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Milford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)875-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Darien",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)876-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Milford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)877-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Milford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)878-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Milford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)879-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wolcott",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)880-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Trumbull",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)881-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Seymour",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)882-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Milford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)883-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)884-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Guilford",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)885-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)886-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "Choice One Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)887-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)888-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Seymour",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)889-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)890-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)891-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)892-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)893-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Derby",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)894-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Ridgefield",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)895-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Trumbull",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)896-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Madison",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)897-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)898-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Darien",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)899-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)900-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)901-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)902-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Global Naps",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)903-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)904-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)905-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)906-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Derby",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)907-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Choice One Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)908-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)909-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)910-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)912-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)913-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)914-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)915-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)916-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)917-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)918-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)919-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)920-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)921-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)922-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Huntington",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)923-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)924-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Huntington",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)925-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Huntington",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)926-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Huntington",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)927-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)928-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)929-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Huntington",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)930-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)931-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)932-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)933-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)934-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)935-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Meriden",
                    "operator": "Global Crossing Local Services-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)936-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)937-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)938-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Redding",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)939-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)940-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)941-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Seymour",
                    "operator": "Bandwidth.com Clec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)942-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)943-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)944-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Huntington",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)945-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)946-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)947-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)948-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)949-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Wallingford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)951-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Milford",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)952-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)953-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)954-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Derby",
                    "operator": "Choice One Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)955-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Fairfield",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)956-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)957-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)960-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)961-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)962-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)963-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)964-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)965-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)966-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Canaan",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)967-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)968-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)969-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)970-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)971-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)972-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Canaan",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)973-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)974-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)975-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)977-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)978-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)979-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)980-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)981-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)982-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Waterbury",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)983-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Conversent Communications Of Connecticut",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)984-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)985-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)986-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Old Greenwich",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)987-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)988-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)989-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)990-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Old Greenwich",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)991-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Norwalk",
                    "operator": "Southern New England Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)992-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Greenwich",
                    "operator": "Cablevision Lightpath",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)993-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)994-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Danbury",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)995-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Bridgeport",
                    "operator": "Brooks Fiber Communications Of Connecticut Inc-ct",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)996-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)997-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Derby",
                    "operator": "Omnipoint Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(203)998-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "Stamford",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(203)999-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "CT",
                    "city": "New Haven",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)200-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Springville",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)201-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bright House Ntws Information Svcs (alabama)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)202-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bright House Ntws Information Svcs (alabama)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)203-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Birch Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)204-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Unknown"
                },
                {
                    "mask": "+1(205)206-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)207-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Springville",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)208-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Big River Telephone Company",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)209-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)210-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)212-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)213-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)214-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)215-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)216-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Alabaster",
                    "operator": "Network Telephone Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)217-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Clanton",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)218-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)219-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)220-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)221-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Jasper",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)222-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)223-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)224-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Pine Belt Broadcasting DBA Pine Belt Tel Comp Svcs",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)225-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Centreville",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)226-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)227-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pell City",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)228-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Trussville",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)229-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)230-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Bessemer",
                    "operator": "Network Telephone Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)231-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)232-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Winfield",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)233-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)234-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)235-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Sbc Internet Services",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)237-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Oneonta",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)238-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)239-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)240-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)241-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)242-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)243-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)244-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)245-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Thorsby",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)246-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)247-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)248-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)249-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)250-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)251-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)252-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)253-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)254-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)255-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Sumiton",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)257-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)258-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Clanton",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)259-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)260-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Bessemer",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)261-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Montevallo",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)262-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Columbiana",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)263-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Tw Telecom Of Alabama LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)264-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)265-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Jasper",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)266-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)267-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Bessemer",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)268-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)269-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Haleyville",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)270-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Fayette",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)271-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Tw Telecom Of Alabama LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)272-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Double Springs",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)273-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Detroit",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)274-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Oneonta",
                    "operator": "Otelco Telephone LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)275-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Jasper",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)276-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)277-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Bessemer",
                    "operator": "Us Lec Of Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)278-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Tw Telecom Of Alabama LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)279-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)280-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Clanton",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)281-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)282-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Jasper",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)283-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)284-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Northport",
                    "operator": "Satellink Paging",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)285-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Gardendale",
                    "operator": "Charter Fiberlink - Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)286-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "West Blocton",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)287-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Clanton",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)288-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Southern Communications Services",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)289-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Warrior",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)290-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)291-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Vincent",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)292-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)294-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Clanton",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)295-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Jasper",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)296-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)297-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)298-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)299-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Clanton",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)300-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Jasper",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)301-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Eutaw",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)302-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Jasper",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)303-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Fayette",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)304-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)305-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)306-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)307-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)308-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)309-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)310-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)312-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Clanton",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)313-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Us Lec Of Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)314-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Us Lec Of Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)315-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Eutaw",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)316-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Centreville",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)317-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)319-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Calera",
                    "operator": "Sbc Internet Services",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)320-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)321-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)322-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)323-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)324-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)325-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)326-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)327-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)328-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)329-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)330-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Northport",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)331-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)332-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Tw Telecom Of Alabama LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)333-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Northport",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)335-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)336-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Epes",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)337-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Centreville",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)338-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pell City",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)339-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Northport",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)340-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Centreville",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)341-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Sumiton",
                    "operator": "Us Lec Of Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)342-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)343-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)344-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)345-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)346-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Eutaw",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)347-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)348-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)349-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)350-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Winfield",
                    "operator": "Citizen Phone",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)351-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Clanton",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)352-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Warrior",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)353-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "West Blocton",
                    "operator": "Tw Telecom Of Alabama LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)354-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)355-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Lincoln",
                    "operator": "Bellsouth Telecommunications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)356-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)357-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Lincoln",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)358-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Alabaster",
                    "operator": "Nuvox Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)359-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Altoona",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)361-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Southern Communications Services",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)362-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pell City",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)363-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Blountsville",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)364-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Gordo",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)365-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)366-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)367-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Carrollton",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)368-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)369-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)370-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)371-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Moundville",
                    "operator": "Moundville Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)372-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Eutaw",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)373-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Aliceville",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)374-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Eutaw",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)375-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Reform",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)376-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "York",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)377-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "York",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)378-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Alabaster",
                    "operator": "Us Lec Of Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)379-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)380-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)381-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)382-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)383-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)384-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Jasper",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)385-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Jasper",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)386-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "West Blocton",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)387-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Jasper",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)388-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Jasper",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)389-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Clanton",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)390-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Warrior",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)391-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)392-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "York",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)393-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)394-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)395-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Sumiton",
                    "operator": "Tw Telecom Of Alabama LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)396-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)397-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Nuvox Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)398-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Lisman",
                    "operator": "Butler Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)399-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Carrollton",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)400-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)401-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)402-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)403-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)404-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Unknown"
                },
                {
                    "mask": "+1(205)405-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pell City",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)406-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Alabaster",
                    "operator": "Tw Telecom Of Alabama LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)408-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)409-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)410-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)412-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Guin",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)413-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)414-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)415-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Clanton",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)416-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Reform",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)417-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Bessemer",
                    "operator": "Nuvox Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)418-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Gardendale",
                    "operator": "Us Lec Of Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)419-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Alabaster",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)420-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)421-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)422-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)423-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)424-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Bessemer",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)425-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Bessemer",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)426-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Bessemer",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)427-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)428-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Bessemer",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)429-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Blountsville",
                    "operator": "Blountsville Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)430-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Hamilton",
                    "operator": "Tw Telecom Of Alabama LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)431-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Vernon",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)432-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Bessemer",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)433-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Graysville",
                    "operator": "Us Lec Of Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)434-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)435-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Jasper",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)436-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Quinton",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)437-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)438-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Southern Communications Services",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)439-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Tw Telecom Of Alabama LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)440-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)441-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)442-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Fayette",
                    "operator": "Tw Telecom Of Alabama LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)443-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Tw Telecom Of Alabama LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)444-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)445-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)446-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Oneonta",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)447-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)448-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Cropwell",
                    "operator": "Tw Telecom Of Alabama LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)449-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Tw Telecom Of Alabama LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)450-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Moundville",
                    "operator": "Southern Communications Services",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)451-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)452-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Springville",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)453-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Network Telephone Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)454-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)455-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Gainesville",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)456-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Horton",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)457-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Butler",
                    "operator": "Pine Belt Cellular",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)458-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)459-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Butler",
                    "operator": "Butler Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)460-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)461-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Bessemer",
                    "operator": "Tw Telecom Of Alabama LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)462-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)463-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Carrollton",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)464-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)465-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Brilliant",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)466-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Horton",
                    "operator": "Hopper Telecommunications LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)467-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Springville",
                    "operator": "Windstream Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)468-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Guin",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)469-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)470-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)471-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Jasper",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)472-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Ragland",
                    "operator": "Ragland Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)473-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pell City",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)474-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Butler",
                    "operator": "Southern Communications Services",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)475-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Bessemer",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)476-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Alabaster",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)477-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Mc Calla",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)478-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)479-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Clanton",
                    "operator": "Momentum Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)480-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)481-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Bessemer",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)482-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)483-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Cordova",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)484-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Tw Telecom Of Alabama LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)485-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Haleyville",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)486-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Haleyville",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)487-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Winfield",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)488-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)489-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Double Springs",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)490-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)491-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Bessemer",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)492-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)493-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Oneonta",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)494-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Haleyville",
                    "operator": "Tw Telecom Of Alabama LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)495-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Guin",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)496-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Eutaw",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)497-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Bessemer",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)498-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Hamilton",
                    "operator": "Alec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)499-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Livingston",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)500-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)501-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)502-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)503-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)504-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)505-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Ragland",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)506-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)507-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)508-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Trussville",
                    "operator": "Bright House Ntws Information Svcs (alabama)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)509-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)510-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)512-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)513-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)514-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Gardendale",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)515-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)516-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)517-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)518-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Centurylink Communications LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)520-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)521-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)522-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Jasper",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)523-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Network Telephone Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)524-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)525-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pell City",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)527-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)528-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Guin",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)529-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)530-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Jasper",
                    "operator": "Bandwidth.com Clec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)531-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)532-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)533-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)534-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)535-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)536-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Broadriver Communication Corporation-ga",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)537-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)538-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Sbc Internet Services",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)539-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Brilliant",
                    "operator": "Alec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)540-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)541-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)542-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)543-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Warrior",
                    "operator": "Us Lec Of Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)544-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Jasper",
                    "operator": "Intermedia Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)545-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)546-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Winfield",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)547-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bandwidth.com Clec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)548-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Lincoln",
                    "operator": "Sbc Internet Services",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)549-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Carbon Hill",
                    "operator": "Bandwidth.com Clec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)550-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)551-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Phil Campbell",
                    "operator": "Charter Fiberlink - Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)552-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)553-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)554-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)556-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)557-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Vernon",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)558-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)559-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Cleveland",
                    "operator": "Blountsville Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)560-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)561-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Us Lec Of Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)562-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)563-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)564-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Alabaster",
                    "operator": "Intermedia Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)565-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Bessemer",
                    "operator": "Intermedia Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)566-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)567-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)568-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)569-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)570-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Hamilton",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)571-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)572-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)573-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)574-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Lisman",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)575-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Livingston",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)576-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)577-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Leeds",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)578-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)579-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)580-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)581-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)582-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Callis Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)583-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)584-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)585-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)586-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)587-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)588-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)589-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Altoona",
                    "operator": "Hopper Telecommunications LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)590-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Warrior",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)591-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)592-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)593-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)594-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Ashville",
                    "operator": "Windstream Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)595-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)596-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Kennedy",
                    "operator": "Frontier Communications Of Lamar County",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)598-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)599-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)601-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)602-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)603-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)604-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Butler",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)605-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Alabaster",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)606-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Sulligent",
                    "operator": "Charter Fiberlink - Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)607-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)608-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Gardendale",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)609-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Livingston",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)610-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Columbiana",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)612-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)613-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)614-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)616-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)617-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)618-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Chelsea",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)619-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Paging Usa South",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)620-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Alabaster",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)621-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Alabaster",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)622-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Oakman",
                    "operator": "Oakman Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)623-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Level 3 Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)624-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Alabaster",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)625-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Oneonta",
                    "operator": "Otelco Telephone LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)626-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Montevallo",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)627-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Double Spgs",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)628-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Calera",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)629-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Odenville",
                    "operator": "Windstream Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)630-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)631-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Gardendale",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)632-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Metro PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)633-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)634-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Winfield",
                    "operator": "Alec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)635-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)636-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "West Blocton",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)637-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Charter Fiberlink - Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)638-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)639-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Neutral Tandem-alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)640-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Moody",
                    "operator": "Windstream Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)641-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)642-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Vincent",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)643-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)646-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Thorsby",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)647-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Warrior",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)648-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Dora",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)649-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Sumiton",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)650-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)651-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)652-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Livingston",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)653-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)654-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pennington",
                    "operator": "Butler Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)655-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Trussville",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)656-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Gordo",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)657-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)658-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Ethelsville",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)660-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Montevallo",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)661-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Trussville",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)662-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Millport",
                    "operator": "Frontier Communications Of Lamar County",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)663-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Alabaster",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)664-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Alabaster",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)665-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Montevallo",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)667-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)668-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Calera",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)669-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Columbiana",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)670-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Columbiana",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)671-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Columbiana",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)672-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Vincent",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)673-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Needham",
                    "operator": "Butler Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)674-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Graysville",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)675-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)676-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)677-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Chelsea",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)678-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Chelsea",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)679-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Montevallo",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)680-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)681-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)682-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)683-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)684-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)685-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Alabaster",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)686-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Parrish",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)687-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)688-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Jemison",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)689-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Bankston",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)690-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Calera",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)692-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)693-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)694-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Gardendale",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)695-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Vernon",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)696-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Sumiton",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)697-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Lynn",
                    "operator": "Oakman Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)698-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Sulligent",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)699-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Leeds",
                    "operator": "Windstream Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)701-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Ymax Communications Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)702-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Leeds",
                    "operator": "Windstream Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)703-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)704-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)705-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)706-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)707-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Hackleburg",
                    "operator": "Southern Communications Services",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)708-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "York",
                    "operator": "Mcc Telephony Of The South",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)709-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)712-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Vernon",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)713-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Cordova",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)714-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)715-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)716-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)717-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Jasper",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)718-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)719-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)720-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bandwidth.com Clec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)721-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Alec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)722-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Nuvox Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)724-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Parrish",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)726-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)727-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Carbon Hill",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)728-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)729-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)731-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)732-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "365 Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)733-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)735-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Warrior",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)737-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Sbc Internet Services",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)739-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)740-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Cordova",
                    "operator": "Bandwidth.com Clec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)741-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)742-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Livingston",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)743-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Graysville",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)744-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Bessemer",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)745-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)746-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)747-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Charter Fiberlink - Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)748-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Fayette",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)750-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)752-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)753-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pell City",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)755-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Clanton",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)757-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)758-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)759-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)760-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Sbc Internet Services",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)763-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Lincoln",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)764-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Comcast Phone Of Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)765-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)766-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)767-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)769-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)770-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)773-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Leeds",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)774-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bandwidth.com Clec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)775-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Chelsea",
                    "operator": "Us Lec Of Alabama",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)776-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Tw Telecom Of Alabama LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)777-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)779-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Aliceville",
                    "operator": "Centurylink Communications LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)780-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)781-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)783-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)785-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)786-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)787-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)788-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)789-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)790-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)791-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)792-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)794-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)795-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Tw Telecom Of Alabama LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)796-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)798-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)799-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)800-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Bessemer",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)801-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)802-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)803-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)804-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)805-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)806-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)807-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)808-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)810-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Bandwidth.com Clec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)812-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pell City",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)814-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pell City",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)815-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)816-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)817-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)818-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)819-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)820-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)821-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)822-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)823-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)824-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)826-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)828-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Reform",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)833-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)834-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Nuvox Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)835-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)836-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)837-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)838-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)841-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)844-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Livingston",
                    "operator": "Cellular South",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)848-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)849-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)853-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)854-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)856-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)857-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Thorsby",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)860-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pinson",
                    "operator": "Corr Wireless Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)861-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)862-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)863-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pell City",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)865-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)866-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)867-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)868-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)869-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)870-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)871-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)873-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)874-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)876-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)877-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)879-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)884-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Pell City",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)886-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)887-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Tuscaloosa",
                    "operator": "Powertel Birmingham Licenses",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)888-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)889-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)893-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Lynn",
                    "operator": "Oakman Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)897-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)901-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)902-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)903-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)904-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Fayette",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)906-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)907-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)908-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)909-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)910-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)912-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)913-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)914-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)915-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)916-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)917-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)918-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)919-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)920-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Bessemer",
                    "operator": "Metro PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)921-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Hamilton",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)923-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)924-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Carbon Hill",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)925-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)926-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Centreville",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)928-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Centreville",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)929-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)930-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)932-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Fayette",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)933-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)934-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)935-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Hackleburg",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)936-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)937-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)938-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "West Blocton",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)939-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)940-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)941-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)942-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)943-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)944-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)945-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)948-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)949-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Deltacom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)951-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)952-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Hamilton",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)954-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)955-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Jemison",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)956-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)957-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)960-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "New Cingular Wireless PCS - GA",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)965-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)966-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)967-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)968-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)969-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)970-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)972-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)975-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)977-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)978-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)979-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)980-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)981-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)982-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)983-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)985-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)986-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Intermedia Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)987-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)988-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)989-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)991-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)992-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)993-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Phil Campbell",
                    "operator": "Centurytel Tel Al LLC (northern) DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)994-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(205)995-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)996-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Bellsouth Telecomm Inc DBA South Central Bell Tel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)998-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Berry",
                    "operator": "Oakman Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(205)999-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "AL",
                    "city": "Birmingham",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)200-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)201-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)202-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)203-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)204-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Mcleodusa Telecommunications Services- Wa",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)205-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)208-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)209-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Neutral Tandem-washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)210-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Fox Communications Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)212-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)213-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)214-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)215-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)216-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)217-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)218-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)219-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)220-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)221-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)222-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)223-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)224-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)225-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)226-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)227-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)228-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)229-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)230-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)232-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)233-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)234-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)235-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)236-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)237-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Richmond Beach",
                    "operator": "Pac - West Telecomm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)238-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Pac - West Telecomm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)239-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)240-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)241-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)242-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)243-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)244-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)245-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Electric Lightwave DBA Integra Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)246-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)248-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)249-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Des Moines",
                    "operator": "Integra Telecom Of Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)250-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Kirkland",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)251-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Kirkland",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)252-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)254-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)255-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)256-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)257-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Comcast Phone Of Washington\/oregon",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)258-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Comcast Phone Of Washington\/oregon",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)259-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Vashon",
                    "operator": "Tw Telecom Of Washington LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)260-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Pac - West Telecomm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)261-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)262-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)263-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)264-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)265-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)266-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)267-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Allegiance Telecom Of Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)268-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)269-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)270-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)271-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)272-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)273-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)274-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)275-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)276-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)277-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)278-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)279-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)280-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Kirkland",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)281-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)282-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)283-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)284-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)285-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)286-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)287-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)288-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Redmond",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)289-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)290-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Kirkland",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)291-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)292-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)293-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)294-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)295-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)296-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)297-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)298-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)299-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Pac - West Telecomm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)300-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)301-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)302-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)303-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)304-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Des Moines",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)305-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)306-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)307-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Neutral Tandem-washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)309-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)310-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)312-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)313-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)314-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)315-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Xo Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)316-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Mbc Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)317-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "World Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)318-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)319-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)320-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)321-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)322-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)323-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)324-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)325-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)326-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)327-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)328-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)329-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)330-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)331-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)332-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)333-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)334-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)335-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)336-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Mci Worldcom Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)337-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)338-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)339-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)340-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)341-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)342-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)343-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)344-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)345-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)346-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)347-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)348-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)349-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)350-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)351-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)352-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)353-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)354-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)355-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)356-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)357-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Xo Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)358-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)359-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)361-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)362-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)363-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)364-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)365-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)366-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)367-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)368-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)369-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)370-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)371-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)372-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)373-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)374-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)375-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)376-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)377-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)378-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)380-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)381-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)382-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)383-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)384-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)386-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)387-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)388-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Eschelon Telecom Of Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)389-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)390-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)391-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)392-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Des Moines",
                    "operator": "Eschelon Telecom Of Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)393-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)394-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)395-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Teltrust Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)396-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)397-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Callerid4u",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)398-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)399-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)400-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Des Moines",
                    "operator": "Xo Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)402-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Eltopia Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)403-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)404-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Redmond",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)405-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)406-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)407-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Xo Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)408-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)409-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)410-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)412-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)414-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Ymax Communications Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)415-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)416-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)417-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)418-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)419-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)420-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "360networks (usa) Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)421-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)422-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)423-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)424-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)426-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)427-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)428-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Xo Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)429-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)430-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Centurylink Communications LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)431-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)432-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Integra Telecom Of Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)433-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)434-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)435-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Tw Telecom Of Washington LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)436-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Electric Lightwave DBA Integra Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)437-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)438-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Xo Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)439-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)440-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)441-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)442-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)443-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)444-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)445-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cbeyond Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)446-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)447-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)448-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)449-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)450-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)451-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Bainbridge Is",
                    "operator": "360networks (usa) Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)452-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)453-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)454-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Electric Lightwave DBA Integra Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)455-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)456-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)457-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)458-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)459-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)461-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)462-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)463-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Vashon",
                    "operator": "Centurytel Of Washington DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)464-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)465-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)466-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)467-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)469-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)470-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)473-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)474-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "World Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)477-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)478-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)479-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)484-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)486-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Peerless Network Of Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)489-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)490-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)491-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)493-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Xo Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)494-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)495-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)496-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)497-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Ymax Communications Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)498-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)499-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)500-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)501-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)504-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)505-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)506-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)508-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)509-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)510-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)512-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)515-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)516-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)517-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)518-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Integra Telecom Of Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)519-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Unknown"
                },
                {
                    "mask": "+1(206)520-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)521-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)522-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)523-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)524-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)525-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)526-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)527-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)528-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)529-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)532-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)533-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Richmond Beach",
                    "operator": "Frontier Communications Northwest Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)534-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)535-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)538-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Mcleodusa Telecommunications Services- Wa",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)540-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)541-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)542-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Richmond Beach",
                    "operator": "Frontier Communications Northwest Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)543-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)544-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)545-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)546-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Richmond Beach",
                    "operator": "Frontier Communications Northwest Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)547-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)548-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)549-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)550-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)551-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)552-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Bandwidth.com Clec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)553-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)554-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)556-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Unknown"
                },
                {
                    "mask": "+1(206)557-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)559-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)560-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)563-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)567-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Centurytel Of Washington DBA Centurylink",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)568-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)569-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Global Crossing Local Services-wa",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)570-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "American Messaging (am)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)571-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)574-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)575-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)576-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Tw Telecom Of Washington LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)577-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Global Crossing Local Services-wa",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)578-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)579-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Kirkland",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)582-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Electric Lightwave DBA Integra Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)583-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)585-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)587-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)588-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Comcast Phone Of Washington\/oregon",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)592-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Des Moines",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)595-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)596-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Hypercube Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)597-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)598-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)599-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)600-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)601-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)602-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)604-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)605-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)607-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)608-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "American Messaging (am)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)609-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "American Messaging (am)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)610-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "American Messaging (am)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)612-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)613-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)615-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)616-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)617-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)618-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)619-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)621-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)622-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)623-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)624-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)625-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)626-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)628-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)629-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Tw Telecom Of Washington LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)631-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)632-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)633-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)634-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)639-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Broadvox-clec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)641-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Xo Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)642-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)643-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "365 Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)645-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)648-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)650-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Kirkland",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)651-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)652-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)653-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Des Moines",
                    "operator": "Global Crossing Local Services-wa",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)654-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)655-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)658-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)659-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Comcast Phone Of Washington\/oregon",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)660-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)661-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)662-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)663-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)664-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)666-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)667-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)669-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)671-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)673-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)674-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)675-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)676-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)678-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)679-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Kirkland",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)680-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)681-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)682-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)683-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Kirkland",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)684-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)685-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)686-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)687-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)689-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)691-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)692-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)694-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)695-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)696-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)697-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)699-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "American Messaging (am)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)701-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)706-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)707-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "X5 Solutions",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)708-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)709-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)713-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)714-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)715-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)716-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)718-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)719-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)720-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)721-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)722-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)723-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)724-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Electric Lightwave DBA Integra Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)725-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)726-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)727-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)728-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)729-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)730-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)731-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)732-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)733-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)734-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)735-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)736-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)737-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)738-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)740-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)743-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Peerless Network Of Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)744-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Electric Lightwave DBA Integra Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)745-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cbeyond Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)747-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)748-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)749-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)753-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Tw Telecom Of Washington LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)754-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Redmond",
                    "operator": "Frontier Communications Northwest Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)755-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)757-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)760-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)762-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)763-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)764-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)765-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)766-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)767-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)768-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)769-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Kirkland",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)770-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)772-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)774-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)777-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)778-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)779-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)780-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Bainbridge Island",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)781-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)782-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)783-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)784-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)786-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)787-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)788-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)789-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)790-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)792-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Xo Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)793-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)794-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)795-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)797-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)799-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)801-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)802-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Mci Worldcom Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)803-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "American Messaging (am)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)805-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Electric Lightwave DBA Integra Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)807-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)808-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)810-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)812-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Electric Lightwave DBA Integra Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)816-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Electric Lightwave DBA Integra Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)817-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)818-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)819-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)824-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Des Moines",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)826-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Xo Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)829-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Eschelon Telecom Of Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)830-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)832-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Xo Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)834-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)835-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)838-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Integra Telecom Of Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)839-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)841-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)842-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Bainbridge Island",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)849-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)850-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Kirkland",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)851-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Kirkland",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)852-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Kirkland",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)853-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Kirkland",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)854-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Kirkland",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)855-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Bainbridge Island",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)856-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Kirkland",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)858-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Electric Lightwave DBA Integra Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)859-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Electric Lightwave DBA Integra Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)860-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)861-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)866-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Global Crossing Local Services-wa",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)870-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Des Moines",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)871-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)876-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Tw Telecom Of Washington LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)877-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Xo Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)878-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Des Moines",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)883-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)884-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)888-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)890-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)892-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Teleport Communications America",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)897-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)898-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Kirkland",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)901-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)902-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Xo Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)903-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)905-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Xo Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)906-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)907-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)909-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)910-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)913-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)914-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)915-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)916-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)917-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)918-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)919-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)920-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)922-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Global Crossing Local Services-wa",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)923-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)925-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)926-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Mci Worldcom Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)930-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)931-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Kirkland",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)932-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)933-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)934-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Broadwing Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)935-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)937-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)938-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)939-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)940-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)941-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)946-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Onvoy",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)947-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)948-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)949-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)953-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)954-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)955-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)956-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)957-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Eschelon Telecom Of Washington",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)962-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)963-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)965-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)969-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)971-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Electric Lightwave DBA Integra Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)972-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)973-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Electric Lightwave DBA Integra Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)975-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)977-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)978-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)979-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)980-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)981-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "T-mobile Usa",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)982-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)984-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "International Telcom, Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)985-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)986-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)987-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)988-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)989-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)991-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)992-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "New Cingular Wireless PCS",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)993-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)994-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)995-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)996-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Usa Mobility Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(206)997-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)998-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Qwest Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(206)999-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "WA",
                    "city": "Seattle",
                    "operator": "Cellco Partnership DBA Verizon Wireless",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)200-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)203-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Gardiner",
                    "operator": "Biddeford Internet Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)204-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Kennebunkport",
                    "operator": "Biddeford Internet Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)205-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Biddeford",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)206-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Sanford",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)208-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Brunswick",
                    "operator": "Ctc Communications Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)209-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)210-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)212-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Lewiston",
                    "operator": "United States Cellular Corp. - Maine",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)213-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Augusta",
                    "operator": "Choice One Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)214-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Calais",
                    "operator": "United States Cellular Corp. - Maine",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)215-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Augusta",
                    "operator": "United States Cellular Corp. - Maine",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)216-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Wells",
                    "operator": "United States Cellular Corp. - Maine",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)217-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Bangor",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)218-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Belfast",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)219-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Scarborough",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)221-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Choice One Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)222-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Gorham",
                    "operator": "Ctc Communications Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)223-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Winterport",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)224-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Livermore",
                    "operator": "Oxford County Telephone & Telegraph Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)225-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Turner",
                    "operator": "Oxford County Telephone & Telegraph Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)226-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Rockland",
                    "operator": "Choice One Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)227-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Presque Isle",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)228-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)229-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Biddeford",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)230-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Camden",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)231-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Fort Kent",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)232-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)233-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)234-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Dixmont",
                    "operator": "Unity Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)235-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Kingfield",
                    "operator": "Somerset Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)236-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Camden",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)237-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Stratton",
                    "operator": "Somerset Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)238-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Fairfield",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)239-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)240-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Lewiston",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)241-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Lewiston",
                    "operator": "Northeast Wireless Networks",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)242-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Augusta",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)243-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Stratton",
                    "operator": "Somerset Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)244-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Southwest Harbor",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)245-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)246-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Stratton",
                    "operator": "Somerset Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)247-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Waterboro",
                    "operator": "Saco River Telephone LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)248-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Augusta",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)249-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Bangor",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)251-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Ogunquit",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)252-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)253-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)254-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Houlton",
                    "operator": "Oxford Cnty Telephone Svc Co, DBA Oxford Netwrks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)255-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Machias",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)256-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Fryeburg",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)257-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Detroit",
                    "operator": "Mid-maine Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)259-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Machiasport",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)262-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Bangor",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)263-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Wesley",
                    "operator": "United States Cellular Corp. - Maine",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)264-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)265-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Kingfield",
                    "operator": "Somerset Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)266-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Ellsworth",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)267-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Oakfield",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)268-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Litchfield",
                    "operator": "Community Service Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)269-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Carmel",
                    "operator": "Hampden Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)270-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Dexter",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)271-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Wesley",
                    "operator": "United States Cellular Corp. - Maine",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)272-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)273-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Warren",
                    "operator": "Warren Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)274-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)275-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Cornerstone Communications",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)276-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Southwest Harbor",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)277-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Saint Albans",
                    "operator": "Hartland & St. Albans Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)278-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Corinna",
                    "operator": "West Penobscot Telephone & Telegraph Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)279-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Brownville",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)280-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Monson",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)281-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Biddeford",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)282-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Biddeford",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)283-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Biddeford",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)284-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Biddeford",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)285-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Corinth",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)286-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Biddeford",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)287-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Augusta",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)288-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Bar Harbor",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)289-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Scarborough",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)290-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Lincoln",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)293-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Vienna",
                    "operator": "Community Service Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)294-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Biddeford",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)296-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Stetson",
                    "operator": "West Penobscot Telephone & Telegraph Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)297-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Eustis",
                    "operator": "Somerset Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)298-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Buxton",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)299-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Bangor",
                    "operator": "AT&T Local",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)303-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Scarborough",
                    "operator": "Oxford Cnty Telephone Svc Co, DBA Oxford Netwrks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)307-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Bangor",
                    "operator": "Oxford Cnty Telephone Svc Co, DBA Oxford Netwrks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)310-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Windham",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)312-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Lewiston",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)313-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Waterville",
                    "operator": "Omnipoint Miami E License",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)314-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Waterville",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)315-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Boothbay Hbr",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)316-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Madawaska",
                    "operator": "United States Cellular Corp. - Maine",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)317-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)318-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)319-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Brunswick",
                    "operator": "Choice One Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)320-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Livermore Falls",
                    "operator": "United States Cellular Corp. - Maine",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)321-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Ctc Communications Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)322-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Belfast",
                    "operator": "United States Cellular Corp. - Maine",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)323-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Belfast",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)324-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Sanford",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)325-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Limestone",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)326-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Castine",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)327-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Bradford",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)328-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Limestone",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)329-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)330-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Lewiston",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)331-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)332-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)333-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Lewiston",
                    "operator": "Oxford Cnty Telephone Svc Co, DBA Oxford Netwrks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)334-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Swans Island",
                    "operator": "Island Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)335-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Stonington",
                    "operator": "Island Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)336-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Buckfield",
                    "operator": "Oxford County Telephone & Telegraph Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)337-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "York",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)338-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Belfast",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)339-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Berwick",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)340-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "New Portland",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)341-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Newport",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)342-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Morrill",
                    "operator": "Northland Telephone Of Maine",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)343-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Guilford",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)344-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Lewiston",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)345-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Mechanic Falls",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)346-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Mechanic Falls",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)347-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Conversent Communications Of Maine",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)348-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Deer Isle",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)349-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Greenville Junction",
                    "operator": "United States Cellular Corp. - Maine",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)350-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Boothbay Harbor",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)351-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "York",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)353-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Lisbon Falls",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)354-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Thomaston",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)355-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Newport",
                    "operator": "Mid-maine Telplus DBA Mid-maine Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)356-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Bangor",
                    "operator": "United States Cellular Corp. - Maine",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)357-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Rumford",
                    "operator": "United States Cellular Corp. - Maine",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)358-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Freedom Ring Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)359-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Sedgwick",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)360-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Wells",
                    "operator": "Mcimetro Access Transmission Services LLC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)361-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Wells",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)362-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Smithfield",
                    "operator": "Somerset Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)363-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "York",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)364-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Rumford",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)365-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Benedicta",
                    "operator": "Northland Telephone Of Maine",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)366-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Vinalhaven",
                    "operator": "Island Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)367-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Deer Isle",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)368-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Newport",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)369-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Rumford",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)370-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Level 3 Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)371-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Georgetown",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)372-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Tenants Harbor",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)373-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Brunswick",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)374-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Blue Hill",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)375-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Sabattus",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)376-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Lewiston",
                    "operator": "Ctc Communications Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)377-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Winthrop",
                    "operator": "Community Service Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)378-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)379-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Garland",
                    "operator": "West Penobscot Telephone & Telegraph Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)380-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Wiscasset",
                    "operator": "United States Cellular Corp. - Maine",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)381-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Bethel",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)382-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Freedom",
                    "operator": "Northland Telephone Of Maine",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)384-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "South Berwick",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)385-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Bangor",
                    "operator": "Paetec Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)386-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Bath",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)388-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Sumner",
                    "operator": "Oxford County Telephone & Telegraph Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)389-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Phippsburg",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)390-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Rockland",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)391-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Biddeford",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)392-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Andover",
                    "operator": "Oxford West Telephone Company",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)393-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Norway",
                    "operator": "United States Cellular Corp. - Maine",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)394-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Old Town",
                    "operator": "Mid-maine Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)395-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Winthrop",
                    "operator": "Community Service Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)396-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Scarborough",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)397-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Smithfield",
                    "operator": "Somerset Telephone Co.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)398-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Fort Kent",
                    "operator": "Northland Telephone Of Maine",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)399-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Skowhegan",
                    "operator": "United States Cellular Corp. - Maine",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)400-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)402-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Lewiston",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)403-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Lincoln",
                    "operator": "Mid-maine Telplus DBA Mid-maine Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)404-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Kenduskeag",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)406-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Brunswick",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)407-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Lisbon Falls",
                    "operator": "Ctc Communications Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)408-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)409-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "Omnipoint Miami E License",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)412-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Ellsworth",
                    "operator": "Time Warner Cbl Info Svc (me) DBA Time Warner Cbl",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)415-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)416-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Pittsfield",
                    "operator": "United States Cellular Corp. - Maine",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)417-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Freeport",
                    "operator": "Sprint Spectrum L.p.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)418-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Rumford",
                    "operator": "Bell Atlantic Nynex Mobile",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)420-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Portland",
                    "operator": "New Cingular Wireless PCS - DC",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(207)422-##-##",
                    "cc": "US",
                    "cd": "USA",
                    "state": "ME",
                    "city": "Sullivan",
                    "operator": "No New England Tel Op DBA Fairpoint Comm",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(207)423-##-##",
        