/*!
* phone-codes/phone-ca.js
* https://github.com/RobinHerbots/Inputmask
* Copyright (c) 2010 - 2017 Robin Herbots
* Canada Database by Yevgen Sukharenko
* Licensed under the MIT license (http://www.opensource.org/licenses/mit-license.php)
* Version: 3.3.7
*/

!function(factory) {
    "function" == typeof define && define.amd ? define([ "../inputmask" ], factory) : "object" == typeof exports ? module.exports = factory(require("../inputmask")) : factory(window.Inputmask);
}(function(Inputmask) {
    return Inputmask.extendAliases({
        phoneca: {
            alias: "abstractphone",
            countrycode: "1",
            phoneCodes: [
                {
                    "mask": "+1(226)200-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Orangeville",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)201-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Hespeler",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)202-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Leamington",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)203-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Guelph",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)204-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Preston",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)205-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Chatham",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)206-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Simcoe",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)207-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Harrow",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)208-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brantford",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)210-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Saint Thomas",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)212-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Saint Thomas",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)213-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)214-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)216-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)217-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Guelph",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)218-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Hespeler",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)220-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)221-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)222-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Goderich",
                    "operator": "Telus Mobility",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)223-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Drayton",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)224-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Globalive Wireless Management Corp.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)225-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Paris",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)227-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brantford",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)228-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Woodstock",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)229-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Chatham",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)230-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Walkerton",
                    "operator": "Telus Mobility",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)231-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Tillsonburg",
                    "operator": "Telus Mobility",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)232-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Woodstock",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)233-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Linwood",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)234-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)235-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)236-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)237-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)238-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)239-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)240-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)241-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)242-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Woodstock",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)243-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)244-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Wellesley",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)246-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Globalive Wireless Management Corp.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)247-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Mcgregor",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)248-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Wheatley",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)249-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Thamesville",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)250-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brantford",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)251-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Guelph",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)252-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Maidstone",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)253-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Woodstock",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)254-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Sarnia",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)255-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Saint Clemnts",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)256-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Owen Sound",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)257-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Walkerton",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)258-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Durham",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)259-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Orangeville",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)262-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Hensall",
                    "operator": "Tuckersmith Communications Co-operative Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)266-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Elmira",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)268-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)270-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)271-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)272-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)275-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Woodslee",
                    "operator": "Gosfield North Communication Co-operative Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)280-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)288-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Saint Jacobs",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)289-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)298-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Acton",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)299-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Guelph",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)300-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Stratford",
                    "operator": "Quadro Communications Co-operative Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)301-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Saint Marys",
                    "operator": "Quadro Communications Co-operative Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)302-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Dublin",
                    "operator": "Quadro Communications Co-operative Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)303-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Mitchell",
                    "operator": "Quadro Communications Co-operative Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)304-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Lucan",
                    "operator": "Quadro Communications Co-operative Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)305-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Quadro Communications Co-operative Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)306-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Listowel",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)307-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Wyoming",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)308-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Ilderton",
                    "operator": "Quadro Communications Co-operative Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)312-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Chatham",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)313-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Sarnia",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)314-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Guelph",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)315-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)316-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)317-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)318-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Galt",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)319-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Hespeler",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)320-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Princeton",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)321-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Otterville",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)322-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Innerkip",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)323-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Drumbo",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)324-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Eastwood",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)325-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Norwich",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)326-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Guelph",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)327-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Acton",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)328-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Rockwood",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)329-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Nairn",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)333-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "New Hamburg",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)336-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)338-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)339-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)343-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Guelph",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)344-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)345-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)346-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)347-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)348-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)349-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Sarnia",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)350-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)353-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Plattsville",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)354-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Stratford",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)355-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Baden",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)356-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)357-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Sarnia",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)358-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)359-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)360-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Hespeler",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)361-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Guelph",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)362-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Galt",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)363-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Emeryville",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)364-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Ridgetown",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)365-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Dresden",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)366-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Breslau",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)367-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Blenheim",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)368-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brantford",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)369-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Elora",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)370-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Fergus",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)371-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Courtright",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)372-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Oil Springs",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)373-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)374-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)375-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Pleasant Park",
                    "operator": "Gosfield North Communication Co-operative Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)376-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)377-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)378-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)379-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Owen Sound",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)381-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brantford",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)383-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Fergus",
                    "operator": "Wightman Communications Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)384-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Elora",
                    "operator": "Wightman Communications Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)387-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brantford",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)388-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brantford",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)393-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Exeter",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)400-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brantford",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)401-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brantford",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)402-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Sarnia",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)409-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Belle River",
                    "operator": "Gosfield North Communication Co-operative Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)420-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Clinton",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)421-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Goderich",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)422-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Wingham",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)423-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Exeter",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)424-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Owen Sound",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)425-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Centralia",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)426-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Crediton",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)427-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Glencoe",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)428-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Neustadt",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)429-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Harriston",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)430-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Listowel",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)431-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Palmerston",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)432-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Durham",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)433-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Chesley",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)434-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Hanover",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)435-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Southampton",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)436-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Walkerton",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)437-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Ayton",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)438-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Paisley",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)439-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Milverton",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)440-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Simcoe",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)441-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Bayfield",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)442-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Dashwood",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)443-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Arthur",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)444-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)445-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Mount Forest",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)446-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Ohsweken",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)447-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Clinton",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)448-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)450-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brantford",
                    "operator": "Globalive Wireless Management Corp.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)453-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Port Elgin",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)454-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Mildmay",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)455-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Clinton",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)456-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)457-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Clinton",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)461-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Wyoming",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)462-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Watford",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)463-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Sombra",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)464-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Port Lambton",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)465-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Petrolia",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)466-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Oil Springs",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)467-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Courtright",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)468-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Corunna",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)469-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brights Grove",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)470-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brigden",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)471-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Alvinston",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)472-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Sarnia",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)473-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Preston",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)474-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Galt",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)475-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Hespeler",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)476-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)477-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Amherstburg",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)478-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Belle River",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)479-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Essex",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)480-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Harrow",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)481-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Maidstone",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)482-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Mcgregor",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)483-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Stoney Point",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)484-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Wheatley",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)485-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Woodslee",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)486-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Guelph",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)488-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Glencoe",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)489-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Belmont",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)490-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Mount Brydges",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)491-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Centralia",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)492-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Crediton",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)493-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brantford",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)494-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Chatham",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)499-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)500-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Guelph",
                    "operator": "Globalive Wireless Management Corp.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)520-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Forest",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)521-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Arkona",
                    "operator": "Execulink Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)523-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Blyth",
                    "operator": "Tuckersmith Communications Co-operative Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)526-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)533-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Galt",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)535-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Preston",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)545-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Aylmer",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)556-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Ayr",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)565-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "New Dundee",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)566-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Hespeler",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)567-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Simcoe",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)580-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)581-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)582-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)583-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brantford",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)584-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Stratford",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)592-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)600-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Globalive Wireless Management Corp.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)606-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Globalive Wireless Management Corp.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)616-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Galt",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)622-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Listowel",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)626-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Chatham",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)627-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Chatham",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)630-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Jarvis",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)632-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Breslau",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)636-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)642-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Ayr",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)646-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)647-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)648-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Shakespeare",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)649-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Bright",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)650-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Shedden",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)651-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Fingal",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)652-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Princeton",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)653-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Sparta",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)654-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Mount Pleasant",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)655-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Scotland",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)656-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Plattsville",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)657-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Beachville",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)658-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Port Stanley",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)659-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Burford",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)660-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Wellesley",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)661-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Saint Marys",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)662-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Meaford",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)663-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)664-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Owen Sound",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)665-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Thornbury",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)666-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)667-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)668-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Owen Sound",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)670-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Wardsville",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)671-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Chatham",
                    "operator": "Managed Network Systems Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)672-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Sarnia",
                    "operator": "Managed Network Systems Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)673-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Managed Network Systems Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)674-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Managed Network Systems Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)675-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "La Salle",
                    "operator": "Managed Network Systems Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)676-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Tecumseh",
                    "operator": "Managed Network Systems Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)678-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)680-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)686-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)688-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)690-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Glencoe",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)696-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Hespeler",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)700-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Globalive Wireless Management Corp.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)706-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Guelph",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)721-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Globility",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)726-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Strathroy",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)727-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Emeryville",
                    "operator": "Gosfield North Communication Co-operative Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)735-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Exeter",
                    "operator": "Hay Communications Co-operative Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)738-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Petrolia",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)747-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)748-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)749-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)750-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)755-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Hespeler",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)757-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)765-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Galt",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)766-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Stratford",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)767-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Listowel",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)772-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)773-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)774-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)776-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Sarnia",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)777-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)778-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Sarnia",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)779-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Stratford",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)780-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Guelph",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)781-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)782-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)783-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)784-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Sarnia",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)785-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)786-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Stratford",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)787-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)788-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Bell Mobility",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)789-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)790-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Guelph",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)791-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)792-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)798-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Chatham",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)799-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Chatham",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)802-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brantford",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)808-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)816-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Atwood",
                    "operator": "Mornington Communications Co-operative Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)817-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Monkton",
                    "operator": "Mornington Communications Co-operative Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)818-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Drayton",
                    "operator": "Mornington Communications Co-operative Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)820-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Guelph",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)821-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Guelph",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)826-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)828-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Acton",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)838-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Rockwood",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)846-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Alvinston",
                    "operator": "Brooke Telecom Co-operative Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)848-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Watford",
                    "operator": "Brooke Telecom Co-operative Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)851-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brantford",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)852-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Stratford",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)868-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)880-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Stratford",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)881-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Chatham",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)882-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Chatham",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)883-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Woodstock",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)884-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)885-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Listowel",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)886-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Sarnia",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)887-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Hespeler",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)888-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Woodstock",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)889-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brussels",
                    "operator": "Tuckersmith Communications Co-operative Ltd.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)894-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Galt",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)909-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Owen Sound",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)910-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Owen Sound",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)919-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)920-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brantford",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)921-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Stratford",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)922-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brantford",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)923-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Owen Sound",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)924-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Hespeler",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)925-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)926-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)927-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)928-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)929-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)930-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Port Elgin",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)931-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Simcoe",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)932-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Sarnia",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)933-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brantford",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)934-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brantford",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)935-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)936-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Leamington",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)937-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brantford",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)938-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brantford",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)939-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Goderich",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)946-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)962-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Guelph",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)968-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)969-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)970-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Tillsonburg",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)971-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Guelph",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)972-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)973-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)974-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Owen Sound",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)975-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Windsor",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)977-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)978-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)979-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Guelph",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)980-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)981-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)982-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)983-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)984-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)985-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "London",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)986-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)987-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)988-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)989-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kitchener",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)990-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Walkerton",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)991-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Mount Forest",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)992-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Port Elgin",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)993-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Tillsonburg",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)995-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Wingham",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(226)996-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Chatham",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(226)999-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Stratford",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(236)237-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(236)430-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Nelson",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(236)431-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Salmon Arm",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(236)432-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Terrace",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(236)433-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "150 Mile House",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(236)888-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vancouver",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(236)999-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vancouver",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(249)220-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Stayner",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(249)221-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Alliston",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(249)222-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Rosseau",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(249)223-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Moonstone",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(249)224-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Otter Lake",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(249)265-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Oba",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(249)266-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Sudbury",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(249)267-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Warren",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(249)268-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Wawa",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(249)269-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Whitefish Falls",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(249)301-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Midland",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(249)302-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Algoma Mills",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(249)357-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Peterborough",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(249)358-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "North Bay",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(249)400-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Mattawa",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(249)700-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Huntsville",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(249)877-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Barrie",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(249)878-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Sudbury",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(249)888-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Barrie",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(249)988-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Parry Sound",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(249)991-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "New Liskeard",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(249)992-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kirkland Lake",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(249)993-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "West Guilford",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(249)994-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kapuskasing",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(249)995-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Huntsville",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(249)996-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Mattawa",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(249)997-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Little Current",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(249)998-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Fenelon Falls",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(249)999-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Espanola",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)200-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Revelstoke",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)201-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Campbell River",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)202-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Campbell River",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)203-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Campbell River",
                    "operator": "Telus Mobility",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)204-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Campbell River",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)205-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Campbell River",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)206-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Alberni",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)207-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Courtenay",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)208-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)209-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Alice",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)210-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Chemainus",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)212-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)213-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)214-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)215-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)216-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)217-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)218-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Courtenay",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)219-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Dawson Creek",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)220-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)221-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Ganges",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)222-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Gulf Islands",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)223-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Boswell",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)224-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort St John",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)225-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Riondel",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)226-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vallican",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)227-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Crawford Bay",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)228-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Parksville",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)229-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Balfour",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)230-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Hardy",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)231-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Trail",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)232-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Toad River",
                    "operator": "Northwestel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)233-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort Erie",
                    "operator": "Northwestel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)234-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Iskut",
                    "operator": "Northwestel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)235-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Telkwa",
                    "operator": "Northwestel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)237-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Baie Dufebvre",
                    "operator": "Northwestel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)238-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Gold Bridge",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)239-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Good Hope Lake",
                    "operator": "Northwestel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)240-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Parksville",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)241-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vernon",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)242-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Tumbler Ridge",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)243-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Beaver Valley",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)244-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)245-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Ladysmith",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)246-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Chemainus",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)247-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Gabriola Island",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)248-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Parksville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)249-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Bouchie Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)251-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Burns Lake",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)252-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Duncan",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)253-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Salmon Arm",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)254-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Creston",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)255-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Bouchie Lake",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)256-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lillooet",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)257-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Tumbler Ridge",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)258-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)259-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Shalalth",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)260-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vernon",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)261-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort St John",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)262-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort St John",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)263-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort St John",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)264-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort St John",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)265-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Nakusp",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)266-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Ucluelet",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)267-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "150 Mile House",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)268-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)269-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fauquier",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)270-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Invermere",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)271-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort St John",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)272-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Golden",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)273-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Princeton",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)274-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Penticton",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)275-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vernon",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)276-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Penticton",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)277-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)278-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fernie",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)279-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kitimat",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)280-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Merritt",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)281-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Woss Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)282-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Sayward",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)283-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Gold River",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)284-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Alice",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)285-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Campbell River",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)286-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Campbell River",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)287-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Campbell River",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)288-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Holberg",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)289-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Ocean Falls",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)290-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Golden",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)291-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lillooet",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)292-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Hedley",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)293-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Princeton",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)294-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)295-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Princeton",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)296-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "150 Mile House",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)297-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Mcleese Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)298-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)299-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Bell Mobility",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)300-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)301-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)302-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "150 Mile House",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)303-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "150 Mile House",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)304-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Castlegar",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)305-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "150 Mile House",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)306-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vernon",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)307-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vernon",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)308-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vernon",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)309-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vernon",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)310-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "",
                    "operator": "Telus",
                    "desc": "Unknown"
                },
                {
                    "mask": "+1(250)312-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)313-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Cache Creek",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)314-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)315-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Merritt",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)316-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Bouchie Lake",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)317-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)318-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)319-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus Mobility",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)320-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)321-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort Erie",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)322-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)323-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)324-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Chemainus",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)325-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Gabriola Island",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)326-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kincolith",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)327-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)328-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Penticton",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)329-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort St John",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)330-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Red Rock",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)331-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Courtenay",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)332-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kyuquot",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)333-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lasquetiis",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)334-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Courtenay",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)335-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Courtenay",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)336-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Cumberland",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)337-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Oyster Bay",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)338-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Courtenay",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)339-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Courtenay",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)340-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Donald",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)341-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Invermere",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)342-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Invermere",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)343-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Field",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)344-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Golden",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)345-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fairview",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)346-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Spilmachen",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)347-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Radium",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)348-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Parson",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)349-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Canal Flats",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)350-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Douglas Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)351-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vernon",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)352-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Nelson",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)353-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kaslo",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)354-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Nelson",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)355-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Slocan",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)356-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)357-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Salmo",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)358-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "New Denver",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)359-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "So Slocan",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)360-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)361-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)362-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Rossland",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)363-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)364-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Trail",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)365-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Castlegar",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)366-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Duncan Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)367-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fruitvale",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)368-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Trail",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)369-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Trout Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)370-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)371-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)372-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)373-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Savona",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)374-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)375-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Westwold",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)376-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)377-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)378-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Merritt",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)379-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Falkland",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)380-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)381-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)382-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)383-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)384-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)385-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)386-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)387-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)388-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)389-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)390-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)391-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)392-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "150 Mile House",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)393-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Hendrix Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)394-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Alexis Creek",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)395-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "100 Mile House",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)396-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Laclahache",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)397-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Forest Grove",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)398-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "150 Mile House",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)399-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Thrums",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)400-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Cumberland",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)401-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Chetwynd",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)402-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Creston",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)403-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Alert Bay",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)404-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Summerland",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)405-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)406-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort St James",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)407-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kitimat",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)408-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Oliver",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)409-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Invermere",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)410-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)412-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)413-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)414-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)415-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)416-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Chemainus",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)417-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Cranbrook",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)418-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)419-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)420-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Cranbrook",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)421-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Cranbrook",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)422-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Skookumchk",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)423-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fernie",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)424-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Yahk",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)425-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Sparwood",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)426-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Cranbrook",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)427-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kimberley",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)428-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Creston",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)429-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Jaffray",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)430-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fernie",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)431-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Creston",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)432-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kimberley",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)433-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Sparwood",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)434-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)435-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Creston",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)436-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Chemainus",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)437-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Summerland",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)438-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Princeton",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)439-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Golden",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)440-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Alkali Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)441-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Cluculz Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)442-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Grandforks",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)443-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Grandforks",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)444-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Grandforks",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)445-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Greenwood",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)446-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Rock Creek",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)447-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Christna Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)448-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)449-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Midway",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)450-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Okanagan Mission",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)451-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)452-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Westbank",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)453-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Ashcroft",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)454-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)455-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lytton",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)456-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "70 Mile House",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)457-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Cache Creek",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)458-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Spences Bridge",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)459-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Clinton",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)460-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Penticton",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)461-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)462-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Penticton",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)463-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Salmon Arm",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)464-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Cranbrook",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)465-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Courtenay",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)466-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Duncan",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)467-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Dawson Creek",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)468-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Parksville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)469-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)470-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)471-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort Ware",
                    "operator": "Northwestel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)472-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)473-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Okanagan Falls",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)474-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)475-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)476-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Tatla Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)477-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)478-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)479-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)480-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)481-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Puntzi",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)482-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Penticton",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)483-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Gt Group Telecom Services Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)484-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Beaverdell",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)485-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Oliver",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)486-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Penticton",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)487-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Penticton",
                    "operator": "Telus",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)488-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Penticton",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)489-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Cranbrook",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)490-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Penticton",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)491-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)492-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Penticton",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)493-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Penticton",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)494-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Summerland",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)495-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Osoyoos",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)496-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Naramata",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)497-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Okanagan Falls",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)498-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Oliver",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)499-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Keremeos",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)500-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort Erie",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)501-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Keremeos",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)502-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Keremeos",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)503-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vernon",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)504-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Campbell River",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)505-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Nelson",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)506-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Keremeos",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)507-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)508-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)509-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Nelson",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)510-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Duncan",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)512-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Trail",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)513-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Castlegar",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)514-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)515-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Salmon Arm",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)516-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)517-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Salmon Arm",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)518-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)519-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)520-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kimberley",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)521-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Trail",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)522-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Tofino",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)523-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Logan Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)524-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vanderhoof",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)525-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Merritt",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)526-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Ganges",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)527-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Hardy",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)528-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Midway",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)529-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Elko",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)530-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Ganges",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)531-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fernie",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)532-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)533-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Chemainus",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)534-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Ucluelet",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)535-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Oliver",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)536-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)537-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Ganges",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)538-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Ganges",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)539-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Gulf Islands",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)540-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vernon",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)541-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vernon",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)542-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vernon",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)543-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vernon",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)544-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Saanich",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)545-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vernon",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)546-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Armstrong",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)547-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lumby",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)548-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Oyama",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)549-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vernon",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)550-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vernon",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)551-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Nelson",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)552-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)553-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Loos",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)554-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)556-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Chetwynd",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)557-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Clements",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)558-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vernon",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)559-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Queen Charlotte",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)560-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Chilako",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)561-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)562-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)563-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)564-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)565-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)566-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Valemount",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)567-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vanderhoof",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)568-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Giscome",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)569-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Mcbride",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)570-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vanderhoof",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)571-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)572-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)573-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)574-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)575-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)576-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)577-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Pritchard",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)578-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)579-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)580-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)581-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Cranbrook",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)582-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Princeton",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)583-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Summerland",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)584-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Grandforks",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)585-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Wellington",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)586-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Parksville",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)587-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Clearwater",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)588-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)589-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)590-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)591-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)592-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)593-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Bridge Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)594-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Parksville",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)595-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)596-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)597-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Duncan",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)598-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)599-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Keremeos",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)600-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Edward",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)601-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Chetwynd",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)602-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kimberley",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)603-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Sparwood",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)605-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Midway",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)606-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Chemainus",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)607-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Parksville",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)608-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Castlegar",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)609-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "100 Mile House",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)612-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)613-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)614-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)615-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Terrace",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)616-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)617-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)618-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)619-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)620-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Horsefly",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)621-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Greenville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)622-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince Rupert",
                    "operator": "City West Cable And Telephone Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)623-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Tumbler Ridge",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)624-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince Rupert",
                    "operator": "City West Cable And Telephone Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)625-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Simpson",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)626-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Masset",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)627-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince Rupert",
                    "operator": "City West Cable And Telephone Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)628-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Edward",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)629-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Pender Harbour",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)630-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prespatou",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)631-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Terrace",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)632-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kitimat",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)633-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Aiyansh",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)634-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)635-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Terrace",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)636-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Stewart",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)637-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Sandspit",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)638-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Terrace",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)639-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kitimat",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)640-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)641-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Terrace",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)642-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Sooke",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)643-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Smithers",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)644-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "100 Mile House",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)645-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)646-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Sooke",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)647-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Renfrew",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)648-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Tachie",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)649-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)650-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Courtenay",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)651-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Atlin",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)652-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Saanich",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)653-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Ganges",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)654-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Saanich",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)655-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Saanich",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)656-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Saanich",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)657-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Saanich",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)658-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)659-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Riske Creek",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)660-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fraser Lake",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)661-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)662-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Mackenzie",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)663-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort St John",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)664-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Sooke",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)665-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Saanich",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)666-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Grandforks",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)667-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)668-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)669-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Saanich",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)670-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Ahousat",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)671-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Hardy",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)672-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Barriere",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)673-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Blue River",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)674-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Clearwater",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)675-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Sorrento",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)676-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vavenby",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)677-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Little Fort",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)678-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Avola",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)679-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Pritchard",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)680-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Mcbride",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)681-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)682-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)683-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Revelstoke",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)684-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Valemount",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)685-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Burns Lake",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)686-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)687-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Castlegar",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)688-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Invermere",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)689-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Oliver",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)690-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort Fraser",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)691-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Burns Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)692-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Burns Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)693-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Trail",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)694-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Grassy Plains",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)695-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Burns Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)696-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Topley",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)697-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Granisle",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)698-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Burns Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)699-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fraser Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)700-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Westbank",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)701-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Duncan",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)702-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Courtenay",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)703-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Courtenay",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)704-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)705-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)706-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "100 Mile House",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)707-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Westbank",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)708-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)709-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Duncan",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)710-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Duncan",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)712-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)713-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)714-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)715-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Duncan",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)716-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)717-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)718-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)719-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Dawson Creek",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)720-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Alberni",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)721-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)722-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)723-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Alberni",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)724-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Alberni",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)725-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Tofino",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)726-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Ucluelet",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)727-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)728-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Bamfield",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)729-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Wellington",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)730-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Alberni",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)731-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Alberni",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)732-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Duncan",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)733-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Cobble Hill",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)734-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)735-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Alberni",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)736-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Alberni",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)737-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Duncan",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)738-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Parksville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)739-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)740-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)741-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)742-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Nimpo Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)743-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Cobble Hill",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)744-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)745-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Youbou",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)746-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Duncan",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)747-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Bouchie Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)748-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Duncan",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)749-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lake Cowichan",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)750-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Mcleod Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)751-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Wellington",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)752-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Parksville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)753-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)754-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)755-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)756-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Wellington",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)757-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Bowser",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)758-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Wellington",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)759-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Rolla",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)760-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Wellington",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)761-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Zeballos",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)762-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)763-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)764-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Okanagan Mission",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)765-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)766-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Winfield",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)767-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Peachland",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)768-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Westbank",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)769-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)770-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Penticton",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)771-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Dease Lake",
                    "operator": "Northwestel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)772-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Wonowon",
                    "operator": "Northwestel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)773-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prophet River",
                    "operator": "Northwestel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)774-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort Erie",
                    "operator": "Northwestel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)775-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort Erie",
                    "operator": "Northwestel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)776-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Muncho Lake",
                    "operator": "Northwestel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)777-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Nelson",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)779-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lower Post",
                    "operator": "Northwestel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)780-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "East Pine",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)781-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Flatrock",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)782-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Dawson Creek",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)783-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Hudsons Hope",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)784-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Dawson Creek",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)785-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort St John",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)786-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Pouce Coupe",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)787-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort St John",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)788-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Chetwynd",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)789-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort St John",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)790-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Likely",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)791-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "108 Mile House",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)792-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Courtenay",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)793-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort St John",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)794-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort St John",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)795-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Dawson Creek",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)796-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)797-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)798-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lakelse",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)799-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Bella Coola",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)800-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)801-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)802-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)803-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Salmon Arm",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)804-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Salmon Arm",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)805-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Revelstoke",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)806-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Dawson Creek",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)807-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)808-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)809-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Penticton",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)812-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)813-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)814-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Revelstoke",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)815-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Duncan",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)816-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)817-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Penticton",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)818-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)819-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)820-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)821-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Parksville",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)822-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)823-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)824-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)825-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)826-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)827-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort St John",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)828-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)829-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Moyie",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)830-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Campbell River",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)831-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kitsault",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)832-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Salmon Arm",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)833-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Salmon Arm",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)834-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Mica Creek",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)835-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Salmon Arm",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)836-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Sicamous",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)837-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Revelstoke",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)838-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Enderby",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)839-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Klemtu",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)840-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Manning Park",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)841-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Hartland",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)842-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Hazelton",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)843-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Willow Bark",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)844-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Houston",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)845-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Houston",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)846-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Telkwa",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)847-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Smithers",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)848-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kitkatla",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)849-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kitwanga",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)850-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Campbell River",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)851-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)852-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)853-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)854-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Dawson Creek",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)855-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "150 Mile House",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)856-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Duncan",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)857-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)858-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)859-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)860-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)861-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)862-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)863-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)864-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)865-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Elkford",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)866-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Creston",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)867-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Sooke",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)868-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)869-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)870-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)871-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Courtenay",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)872-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Okanagan Mission",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)873-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Okanagan Mission",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)874-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Chetwynd",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)875-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Chetwynd",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)876-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Smithers",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)877-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Smithers",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)878-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)879-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kamloops",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)880-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)881-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)882-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)883-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)884-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)885-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)886-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)887-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Grasmere",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)888-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)889-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)890-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Courtenay",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)891-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)892-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Terrace",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)893-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)894-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Clearwater",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)895-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Campbell River",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)896-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)897-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Courtenay",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)898-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Courtenay",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)899-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)900-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)901-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Hazelton",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)902-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Hardy",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)903-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Hudsons Hope",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)904-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Alice",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)905-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Parksville",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)906-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)907-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vernon",
                    "operator": "Telus",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)908-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kimberley",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)909-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Parksville",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)910-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Sparwood",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)912-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Ladysmith",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)913-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Alberni",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)914-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Campbell River",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)915-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)916-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Nakusp",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)917-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Smithers",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)918-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Alberni",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)919-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Cranbrook",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)920-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)921-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Trail",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)922-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Terrace",
                    "operator": "Bell Mobility",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)923-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Campbell River",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)924-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Ladysmith",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)925-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Bouchie Lake",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)926-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Campbell River",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)927-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Parksville",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)928-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Beaver Cove",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)929-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Cobble Hill",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)930-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Ganges",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)931-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Ganges",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)932-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lake Cowichan",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)933-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lantzville",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)934-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Tahsis",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)935-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Cortez Island",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)936-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Merritt",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)937-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Parksville",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)938-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vernon",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)939-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Golden",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)940-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)941-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Courtenay",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)942-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Lillooet",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)943-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kaslo",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)944-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Vanderhoof",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)945-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "100 Mile House",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)946-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fernie",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)947-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Parksville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)949-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Hardy",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)951-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Parksville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)952-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)953-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)954-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Parksville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)955-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Celista",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)956-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Port Mcneill",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)957-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Bella Bella",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)960-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)961-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)962-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)963-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)964-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)965-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Summit Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)966-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Hansard",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)967-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Chief Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)968-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Dunster",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)969-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Winter Harbor",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)970-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)971-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Salmon Valley",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)972-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Bear Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)973-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Sointula",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)974-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Alert Bay",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)975-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Terrace",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)977-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Creston",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)978-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)979-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)980-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kelowna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)981-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Prince George",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)982-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Hagersville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)983-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Bouchie Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)984-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Gt Group Telecom Services Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)985-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Bouchie Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)988-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Mackenzie",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)989-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Wildwood",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)990-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Mackenzie",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(250)991-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Bouchie Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)992-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Bouchie Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)993-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Kersley",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)994-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Wells",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)995-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)996-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Fort St James",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)997-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Mackenzie",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)998-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Hixon",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(250)999-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "BC",
                    "city": "Victoria",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)203-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Ottawa",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)212-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Jockvale",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)221-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Orleans",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)263-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Belleville",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(343)264-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brockville",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(343)265-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Deseronto",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)266-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kingston",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)267-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Napanee",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)268-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Arden",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)269-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Bancroft",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)270-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Belleville",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)271-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brighton",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)272-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Northbrook",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)273-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Plevna",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)290-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kingston",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)291-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Ottawa",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)300-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Brockville",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)333-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kingston",
                    "operator": "Globalive Wireless Management Corp.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(343)344-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kingston",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)355-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Belleville",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)356-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Cornwall",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)357-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Bancroft",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)358-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kingston",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)359-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kananaskis",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)360-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Ottawa",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)361-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Renfrew",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)362-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Belleville",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)363-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kingston",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(343)364-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kingston",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(343)369-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Pembroke",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(343)370-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Cornwall",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(343)400-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Perth",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(343)477-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kingston",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)478-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Napanee",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)479-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Gananoque",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)600-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Belleville",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)688-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Ottawa",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)689-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Orleans",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)690-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kananaskis",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)700-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Ottawa",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)777-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Ottawa",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(343)800-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Smiths Falls",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)882-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Ottawa",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)883-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Ottawa",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)884-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Kingston",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)885-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Cornwall",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)886-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Vankleek Hill",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)887-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Ottawa",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(343)925-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Ottawa",
                    "operator": "Yak Communications (canada) Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(365)266-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Bradford",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(365)540-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Tottenham",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(365)560-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Beeton",
                    "operator": "Comwave Networks",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(365)800-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Oshawa",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)200-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)201-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)202-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)203-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)204-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)205-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)206-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)207-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)208-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)209-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)210-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)212-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)213-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)214-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)215-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)216-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)217-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)218-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)219-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)220-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)221-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)222-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Wrentham",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)223-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Taber",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)224-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Bowden",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)225-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)226-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)227-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Innisfail",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)228-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)229-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)230-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)231-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)232-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)233-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)234-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)235-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)236-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)237-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)238-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)239-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)240-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)241-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)242-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)243-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)244-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)245-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)246-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)247-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)248-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)249-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)250-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)251-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)252-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)253-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)254-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)255-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)256-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)257-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)258-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)259-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)260-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)261-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)262-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)263-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)264-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)265-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)266-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)267-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)268-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)269-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)270-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)271-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)272-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)273-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)274-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)275-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)276-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)277-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)278-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)279-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)280-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)281-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)282-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)283-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)284-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)285-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)286-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)287-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)288-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)289-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)290-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)291-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)292-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)293-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)294-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)295-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)296-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)297-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)298-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)299-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)300-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)301-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)302-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)303-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)304-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)305-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)306-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Okotoks",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)307-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)308-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)309-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)310-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "",
                    "operator": "Telus",
                    "desc": "Unknown"
                },
                {
                    "mask": "+1(403)312-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)313-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)314-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)315-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)316-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Airdrie",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)317-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)318-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)319-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)320-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)321-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Drumheller",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)322-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Rocky Mountain House",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)323-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Stettler",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)324-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Strathmore",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)325-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Strathmore",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)326-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Cereal",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)327-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)328-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)329-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)330-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)331-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)332-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)333-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)334-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Drumheller",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)335-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Didsbury",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)336-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "High River",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)337-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Carstairs",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)338-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)339-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Port Perry",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)340-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)341-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)342-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)343-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)344-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Coutts",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)345-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Coaldale",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)346-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)347-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)348-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)349-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)350-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)351-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)352-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)353-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)354-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)355-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)356-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)357-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)358-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)359-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)360-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)361-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Strathmore",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)362-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Brooks",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)363-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Brooks",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)364-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Delia",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)365-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)366-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)367-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)368-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Rumsey",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)369-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)370-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)371-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)372-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Crowsnest Pass",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)373-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)374-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)375-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)376-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Brooks",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)377-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Tilley",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)378-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Duchess",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)379-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Bindloss",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)380-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)381-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)382-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)383-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)384-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)385-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)386-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)387-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)388-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)389-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)390-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)391-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)392-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)393-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)394-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)395-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Cayley",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)396-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)397-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)398-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)399-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)400-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)401-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)402-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Globalive Wireless Management Corp.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)404-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)405-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Coaldale",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)406-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)407-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)408-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)409-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Brooks",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)410-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)412-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Three Hills",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)413-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Coronation",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)414-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Oyen",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)415-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Olds",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)416-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Taber",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)417-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Veteran",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)418-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Rocky Mountain House",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)419-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Sundre",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)420-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Airdrie",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)421-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Warner",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)422-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "High River",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)423-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Vulcan",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)424-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Vauxhall",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)425-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Three Hills",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)426-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Sundre",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)427-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Brooks",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)428-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)429-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Rocky Mountain House",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)430-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Stettler",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)431-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Banff",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)432-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Port Perry",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)433-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Oyen",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)434-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lake Louise",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)435-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Hanna",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)436-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Drumheller",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)437-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)438-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Olds",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)439-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Didsbury",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)440-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)441-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)442-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Trochu",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)443-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Three Hills",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)444-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)445-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Three Hills",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)446-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Coronation",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)447-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Consort",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)448-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Cardston",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)449-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Bowden",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)450-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)451-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)452-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)453-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)454-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)455-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)456-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Globility",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)457-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)458-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)459-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Crowsnest Pass",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)460-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)461-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)462-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)463-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)464-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)465-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)466-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)467-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)468-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Claresholm",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)469-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "High River",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)470-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)471-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)472-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)473-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)474-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)475-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)476-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)477-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)478-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)479-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)480-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Strathmore",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)481-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)482-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Milk River",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)483-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)484-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Port Perry",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)485-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Vulcan",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)486-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Vulcan",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)487-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)488-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)489-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Claresholm",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)490-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Claresholm",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)491-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Milk River",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)492-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Milk River",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)493-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Canmore",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)494-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Drumheller",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)495-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Hanna",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)496-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Vulcan",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)497-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Banff",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)498-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "High River",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)499-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Strathmore",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)500-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)501-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Brooks",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)502-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)503-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)504-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)505-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)506-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)507-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Olds",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)508-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)509-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)510-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)512-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)513-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)514-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)515-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)516-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)517-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)518-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Didsbury",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)519-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)520-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)521-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)522-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lake Louise",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)523-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)524-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)525-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)526-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)527-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)528-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)529-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)530-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)531-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)532-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)533-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Rockyford",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)534-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Arrowwood",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)535-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)536-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)537-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)538-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)539-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)540-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)541-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)542-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)543-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)544-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Ralston",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)545-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Bow Island",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)546-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Acme",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)547-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)548-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)549-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Stavely",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)550-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)551-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Vauxhall",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)552-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Altario",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)553-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Fort Macleod",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)554-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)556-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Olds",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)557-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Fort Macleod",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)558-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Longview",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)559-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Olds",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)560-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)561-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)562-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Crowsnest Pass",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)563-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Crowsnest Pass",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)564-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Crowsnest Pass",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)565-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Empress",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)566-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Cessford",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)567-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)568-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)569-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)570-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)571-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)572-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Carbon",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)573-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Penhold",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)574-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Gadsby",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)575-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Veteran",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)576-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Veteran",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)577-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Consort",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)578-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Coronation",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)579-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Byemoor",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)580-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)581-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)582-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Crowsnest Pass",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)583-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Crowsnest Pass",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)584-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Bow Island",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)585-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)586-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Olds",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)588-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)589-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)590-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)591-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Kananaskis",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)592-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)593-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Bell Mobility",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)594-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Bell Mobility",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)595-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Ralston",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)596-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Bell Mobility",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)597-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)598-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)599-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Milo",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)600-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Black Falds",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)601-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "High River",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)602-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "High River",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)603-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "High River",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)604-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)605-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)606-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)607-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)608-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)609-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Canmore",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)612-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)613-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)614-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)615-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)616-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)617-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)618-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)619-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)620-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)621-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Canmore",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)622-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Vauxhall",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)623-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Crowsnest Pass",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)624-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Port Perry",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)625-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Claresholm",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)626-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Glenwood",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)627-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Port Perry",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)628-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Cowley",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)629-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)630-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)631-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Torrington",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)632-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Port Perry",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)633-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Brooks",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)634-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)635-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)636-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Sundre",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)637-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Cremona",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)638-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Sundre",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)639-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Granum",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)640-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)641-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Bassano",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)642-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Warner",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)643-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Carmangay",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)644-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Standard",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)645-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)646-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Nanton",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)647-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Milk River",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)648-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)649-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "High River",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)650-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)651-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)652-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "High River",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)653-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Cardston",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)654-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Vauxhall",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)655-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Grassy Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)656-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)657-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Bowden",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)658-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Bentley",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)659-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Cardston",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)660-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)661-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)662-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)663-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)664-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Oyen",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)665-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Craigmyle",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)666-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Etzikom",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)667-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)668-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Gt Group Telecom Services Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)669-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)670-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)671-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)672-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Olds",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)673-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Exshaw",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)674-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Exshaw",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)675-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Canmore",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)676-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Sibbald",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)677-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Rosebud",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)678-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Canmore",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)679-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Canmore",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)680-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)681-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)682-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Claresholm",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)683-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Port Perry",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)684-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Blackie",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)685-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)686-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)687-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Granum",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)688-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Canmore",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)689-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)690-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)691-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)692-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)693-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)694-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)695-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)696-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)697-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)698-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)699-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)700-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)701-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)702-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)703-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)704-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Ponoka",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)705-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)706-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Claresholm",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)707-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Canmore",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)708-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)709-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Cochrane",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)710-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)712-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)713-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)714-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)715-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)716-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)717-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)718-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)719-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)720-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)721-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Nordegg",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)722-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Caroline",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)723-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)724-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)725-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Hays",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)726-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)727-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)728-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Spruceview",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)729-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Leslieville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)730-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)731-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)732-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Picture Butte",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)733-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "New Dayton",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)734-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Gleichen",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)735-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)736-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)737-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Stand Off",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)738-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Iron Springs",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)739-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Enchant",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)740-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Stettler",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)741-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Stettler",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)742-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Stettler",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)743-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Stettler",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)744-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)745-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Picture Butte",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)746-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Eckville",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)747-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Alix",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)748-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Bentley",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)749-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Delburne",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)750-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)751-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Cowley",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)752-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Raymond",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)753-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Crowsnest Pass",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)754-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)755-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)756-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Stirling",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)757-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Barons",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)758-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Magrath",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)759-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Magrath",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)760-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Banff",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)761-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Saskatchewan River Crossing",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)762-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Banff",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)763-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Banff",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)764-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)765-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)766-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)767-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)768-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Airdrie",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)769-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)770-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Gt Group Telecom Services Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)771-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)772-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Morrin",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)773-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Elnora",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)774-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Gt Group Telecom Services Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)775-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Gt Group Telecom Services Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)776-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Gt Group Telecom Services Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)777-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)778-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Banff",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)779-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Youngstown",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)781-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)782-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lacombe",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)783-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Ponoka",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)784-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Clive",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)785-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Ponoka",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)786-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lacombe",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)787-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Hussar",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)788-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Mirror",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)789-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lacombe",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)790-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Ponoka",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)791-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Olds",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)792-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lomond",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)793-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Brooks",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)794-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Brooks",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)795-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)796-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)797-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)798-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)799-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Globalstar",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)800-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)801-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)802-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)803-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)804-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)805-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)806-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)807-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)808-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)809-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)812-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Canmore",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)813-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)814-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Strathmore",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)815-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)816-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)817-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)818-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)819-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)820-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Drumheller",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)821-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Drumheller",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)822-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "East Coulee",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)823-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Drumheller",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)824-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Nobleford",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)826-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)827-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)828-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)829-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)830-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)831-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)832-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Seven Persons",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)833-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Burdett",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)834-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Irvine",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)835-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)836-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)837-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)838-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Hilda",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)839-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Schuler",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)840-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Cochrane",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)841-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "High River",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)842-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Okotoks",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)843-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Rimbey",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)844-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Rocky Mountain House",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)845-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Rocky Mountain House",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)846-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Rocky Mountain House",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)847-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Rocky Mountain House",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)848-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)849-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)850-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)851-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Cochrane",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)852-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)853-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Veteran",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)854-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Hanna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)855-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Cochrane",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)856-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Drumheller",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)857-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Hanna",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)858-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Sylvan Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)859-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Waterton Park",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)860-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)861-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)862-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)863-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)864-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Sylvan Lake",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)865-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Innisfail",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)866-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)867-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Foremost",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)868-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Manyberries",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)869-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)870-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)871-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Rocky Mountain House",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)872-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)873-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)874-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)875-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)876-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Big Valley",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)877-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)878-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)879-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)880-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)881-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Morley",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)882-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Castor",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)883-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Donalda",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)884-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Halkirk",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)885-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Black Falds",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)886-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Penhold",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)887-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Sylvan Lake",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)888-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)889-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)890-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)891-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)892-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)893-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Elkwater",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)894-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)895-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Rocky Mountain House",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)896-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)897-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Champion",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)898-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Jenner",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)899-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)901-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Strathmore",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)902-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Strathmore",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)903-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Globalive Wireless Management Corp.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)904-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Port Perry",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)905-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)906-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Yak Communications (canada) Corp.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)907-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Cochrane",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)908-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "High River",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)909-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)910-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)912-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Airdrie",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)913-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Ponoka",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)914-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Trochu",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)915-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)916-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Stettler",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)917-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Okotoks",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)918-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)919-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)920-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)921-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)922-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)923-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)924-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Three Hills",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)925-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Brooks",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)926-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)927-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Globalstar",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)928-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)929-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)930-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)931-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)932-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Cochrane",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)933-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Turner Valley",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)934-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Strathmore",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)935-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Irricana",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)936-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Langdon",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)937-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Walsh",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)938-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Okotoks",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)939-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Okotoks",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)940-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Carstairs",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)941-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Crossfield",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)942-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Lethbridge",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)943-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)944-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)945-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Airdrie",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)946-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Crossfield",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)947-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Beiseker",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)948-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Airdrie",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)949-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Bragg Creek",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)951-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Banff",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)952-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)953-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Canmore",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)954-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Langdon",
                    "operator": "Bragg Communications Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)955-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)956-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Bell West Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)957-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)960-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Airdrie",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)961-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Canmore",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)962-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Strathmore",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)963-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Ponoka",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)964-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Rolling Hills",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)965-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Brocket",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)966-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)967-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)968-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)969-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)970-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)971-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)972-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Acadia Valley",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)973-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)974-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)975-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)977-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)978-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)979-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Medicine Hat",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)980-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Airdrie",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)981-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Cochrane",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)982-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Okotoks",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)983-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Strathmore",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)984-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)985-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Banff",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)986-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Red Deer",
                    "operator": "Shaw Telecom Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)987-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Globalstar",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)988-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)989-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Sunchild Ochiese",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)990-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)991-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)992-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)993-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)994-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Olds",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)995-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Okotoks",
                    "operator": "Telus",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)996-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Banff",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)997-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Globalstar",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(403)998-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(403)999-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "AB",
                    "city": "Calgary",
                    "operator": "Telus Mobility",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)200-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)201-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)202-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)203-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)204-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)205-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)206-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)207-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)208-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)209-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)210-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)212-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)213-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)214-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)215-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)216-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)217-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)218-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)219-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)220-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)221-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)222-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)223-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)224-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)225-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)226-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)227-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)228-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)229-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)230-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)231-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)232-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)233-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)234-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)235-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)236-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)237-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)238-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Globility",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)239-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)240-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)241-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)242-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)243-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)244-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)245-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)246-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)247-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)248-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)249-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)250-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)251-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)252-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)253-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)254-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)255-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)256-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)258-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)259-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)260-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)261-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)262-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)263-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)264-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)265-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)266-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)267-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)268-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)269-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)270-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)271-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)272-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)273-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)274-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)275-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)276-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)277-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)278-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)279-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)280-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)281-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)282-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)283-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)284-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)285-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)286-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)287-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)288-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)289-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)290-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)291-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)292-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)293-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)294-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)295-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)296-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)297-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)298-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)299-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)300-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)301-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)302-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)303-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)304-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)305-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)306-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)307-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)308-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)309-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)310-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "",
                    "operator": "Bell Canada",
                    "desc": "Unknown"
                },
                {
                    "mask": "+1(416)312-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)313-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)314-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)315-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)316-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)317-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)318-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)319-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)320-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)321-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)322-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)323-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)324-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)325-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)326-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)327-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)328-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)329-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)330-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)331-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)332-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)333-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)334-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)335-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)336-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)337-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)338-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)339-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)340-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)341-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)342-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)343-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)344-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)345-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)346-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)347-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)348-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)349-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)350-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)351-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)352-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)353-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)354-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)355-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)356-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)357-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)358-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)359-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)360-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)361-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)362-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)363-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)364-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)365-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)366-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)367-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)368-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)369-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)370-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)371-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)372-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)373-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)374-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)375-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)376-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)377-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)378-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)379-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)380-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)381-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)382-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)383-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)384-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)385-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)386-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)388-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)389-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)390-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)391-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)392-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)393-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)394-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)395-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)396-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)397-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)398-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)399-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)400-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)401-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)402-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)403-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)404-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)405-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)406-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)407-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)408-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)409-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)410-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)412-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)413-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)414-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)415-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)417-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)418-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)419-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)420-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)421-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)422-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)423-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)424-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)425-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)426-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)427-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)428-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)429-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)430-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)431-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)432-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)433-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)434-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)435-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)436-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)438-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)439-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)440-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)441-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)442-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)443-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)444-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)445-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)446-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)447-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)448-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)449-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)450-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)451-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)452-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)453-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)454-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)455-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)456-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)457-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)458-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)459-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)460-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)461-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)462-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)463-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)464-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)465-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)466-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)467-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)468-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)469-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)470-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)471-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)472-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)473-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)475-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)476-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)477-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)478-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)479-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)480-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)481-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)482-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)483-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)484-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)485-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)486-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)487-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)488-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)489-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)490-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)491-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)492-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)493-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)494-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)495-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)496-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)497-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)498-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)499-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)500-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)501-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)502-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)503-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)504-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)505-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)506-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)507-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)508-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)509-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)510-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)512-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)513-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)514-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)515-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)516-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)517-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)518-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)519-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)520-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)521-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)522-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)523-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)524-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)525-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)526-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)527-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)528-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)529-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)530-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)531-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)532-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)533-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)534-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)535-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)536-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)537-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)538-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)539-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)540-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)541-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)542-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)543-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)544-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)545-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)546-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)547-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)548-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)549-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)550-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)551-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)552-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)553-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)554-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)556-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)557-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)558-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)559-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)560-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)561-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)562-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)563-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)564-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)565-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)566-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)567-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)568-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)569-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)570-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)571-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)572-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)573-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)574-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)575-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)576-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)577-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)578-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)579-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)580-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)581-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)582-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)583-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)585-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)586-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)587-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)588-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)589-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)590-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)591-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)592-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)593-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)594-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)595-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)596-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)597-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)598-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)599-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)600-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)601-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)602-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)603-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)604-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)605-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)606-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)607-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)608-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)609-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)612-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)613-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telnet Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)614-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)615-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)616-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)617-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)618-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)619-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)620-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)621-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)622-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)623-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)624-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)625-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)626-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)627-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)628-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)629-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)630-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)631-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)632-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)633-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)634-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)635-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)636-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)637-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)638-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)639-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)640-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)641-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)642-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)643-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)644-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)645-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)646-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)648-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)649-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)650-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)651-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)652-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)653-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)654-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)655-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)656-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)657-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)658-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)659-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)660-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)661-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)662-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)663-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)664-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)665-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)666-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)667-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)668-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)669-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)670-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)671-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)673-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)674-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)675-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)676-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)677-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)678-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)679-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)680-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)681-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)682-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)683-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)684-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)685-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)686-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)687-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)688-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)689-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)690-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)691-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)692-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)693-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)694-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)695-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)696-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)697-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)698-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)699-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)700-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)701-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)702-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)703-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)704-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)705-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)706-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)707-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)708-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)709-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)710-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)712-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)713-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)714-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)715-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)716-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)717-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)718-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)719-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)720-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)721-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)722-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)723-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)724-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)725-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)726-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)727-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)728-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)729-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)730-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)731-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)732-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)733-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)734-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)735-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)736-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)737-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)738-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)739-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)740-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)741-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)742-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)743-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)744-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)745-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)746-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)747-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)748-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)749-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)750-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)751-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)752-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)753-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)754-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)755-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)756-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)757-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)758-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)759-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)760-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)761-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)762-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)763-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)764-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)765-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)766-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)767-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)768-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)769-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)770-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)771-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)772-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)773-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)774-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)775-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)776-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)777-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)778-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)779-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)780-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)781-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)782-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)783-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)784-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)785-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)786-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)787-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)788-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)789-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)790-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)791-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)792-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)793-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)794-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)795-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)796-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)797-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)798-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)799-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)800-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)801-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)802-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)803-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)804-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)805-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)806-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)807-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)808-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)809-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)812-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)813-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)814-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)815-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)816-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)817-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)818-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)819-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)820-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)821-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)822-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)823-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)824-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)825-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)826-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)827-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)828-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)829-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)830-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)831-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)832-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)833-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)834-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)835-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)836-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)837-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)838-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)839-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)840-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)841-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)842-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)843-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)844-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)845-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)846-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)847-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)848-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)849-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)850-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)852-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)853-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Exatel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)854-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)855-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Globility",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)856-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)857-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)858-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)859-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)860-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)861-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)862-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)863-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)864-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)865-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)866-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)867-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)868-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)869-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)870-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)871-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)872-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)873-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)874-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)875-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)876-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)877-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)878-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)879-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)880-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)881-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)882-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)883-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Integrated Communications",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)884-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)885-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)886-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)887-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)888-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)889-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)890-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)891-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)892-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)893-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)894-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)895-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)896-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)897-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)898-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)899-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)900-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)901-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)902-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)903-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)904-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)906-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)907-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)908-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)909-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)910-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)912-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)913-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)914-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)915-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)916-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)917-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)918-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)919-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)920-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)921-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)922-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)923-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)924-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)925-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)926-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)927-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)928-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)929-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)930-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)931-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)932-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)933-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)934-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)935-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)936-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)937-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)938-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)939-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)940-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)941-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)943-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)944-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)945-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)946-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)947-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)948-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)949-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)951-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)952-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)953-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)954-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)955-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)956-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)957-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)960-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)961-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)962-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)963-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)964-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)965-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)966-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)967-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)968-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)969-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)970-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)971-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)972-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)973-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)974-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)975-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)976-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "",
                    "operator": "Bell Canada",
                    "desc": "Unknown"
                },
                {
                    "mask": "+1(416)977-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)978-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)979-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)980-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)981-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)982-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)983-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)984-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)985-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)986-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)987-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(416)988-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)989-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)990-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)991-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)992-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)993-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)994-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)995-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)996-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)997-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)998-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(416)999-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "ON",
                    "city": "Toronto",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)200-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Baie St Paul",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)201-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Clermont",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)202-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "La Malbaie",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)203-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Jean Ile D Orleans",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)204-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)205-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Lambert De Lauzon",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)206-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Montmagny",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)207-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Marie De Beauce",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)208-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)209-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Marie De Beauce",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)210-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Rogers Communications Partnership (cable)",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)212-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Alma",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)213-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Jonquiere",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)214-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Tadoussac",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)215-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Georges De Beauce",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)216-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Raymond",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)217-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Beauceville",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)218-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Felicien",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)219-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Baie St Paul",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)220-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Georges De Beauce",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)221-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Georges De Beauce",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)222-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Georges De Beauce",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)223-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Lucie De Beauregard",
                    "operator": "Sogetel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)224-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Rene De Matane",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)225-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Georges De Beauce",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)226-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Georges De Beauce",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)227-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Georges De Beauce",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)228-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Georges De Beauce",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)229-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "La Romaine",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)230-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Georges De Beauce",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)231-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Austin Moutains",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)232-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Bergeronnes",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)233-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Escoumins",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)234-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Montmagny",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)235-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Tadoussac",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)236-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Sacre Coeur",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)237-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Baie St Catherine",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)238-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Anne De Portneuf",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)239-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Dolbeau",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)240-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Baie St Paul",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)241-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Montmagny",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)242-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Tete A La Baleine",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)243-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Raphael De Bellechasse",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)244-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Justine De Newton",
                    "operator": "Sogetel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)245-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Lac Frontiere",
                    "operator": "Sogetel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)246-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Cap St Ignace",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)247-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "L Islet",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)248-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Montmagny",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)249-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Fabien De Panet",
                    "operator": "Sogetel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)250-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Montmagny",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)251-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Prime",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)252-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Montmagny",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)253-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Vallee Jonction",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)254-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)255-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)256-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "La Dore",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)257-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Magloire",
                    "operator": "Sogetel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)258-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Girardville",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)259-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Francois",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)260-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)261-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)262-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)263-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)264-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)265-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)266-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)267-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Rose De Watford",
                    "operator": "Sogetel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)268-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Marc Des Carrieres",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)269-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Riviere Au Renard",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)270-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "La Malbaie",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)271-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)272-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Anse St Jean",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)274-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Normandin",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)275-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Roberval",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)276-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Dolbeau",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)277-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Ubalde",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)278-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Georges De Beauce",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)279-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Albanel",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)280-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Hauterive",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)281-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Thetford Mines",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)282-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Hauterive",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)283-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Donnacona",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)284-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Donnacona",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)285-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Donnacona",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)286-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Portneuf",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)287-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Fermont",
                    "operator": "Telebec Ltee.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)288-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "La Martre",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)289-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Thecle",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)290-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Chicoutimi",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)291-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Montmagny",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)292-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Riviere Du Loup",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)293-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Hauterive",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)294-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Baie Comeau",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)295-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Hauterive",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)296-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Baie Comeau",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)297-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Hauterive",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)298-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Baie Comeau",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)299-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Alexis De Matapedia",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)300-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Philippe De Neri",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)301-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Delisle",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)302-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Milot",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)303-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Laterriere",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)304-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Levis",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)305-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Thetford Mines",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)306-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "La Baie",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)307-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Felicien",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)308-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Pascal",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)309-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Fulgence",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)310-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "",
                    "operator": "Bell Canada",
                    "desc": "Unknown"
                },
                {
                    "mask": "+1(418)312-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Catharines Thorold",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)313-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Georges De Beauce",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)314-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Riviere Du Loup",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)315-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Pacome",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)316-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Notre Dame Des Laurentides",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)317-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Distributel",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)318-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Rimouski",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)319-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Alma",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)320-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Matapedia",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)321-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Alma",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)322-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Adelphe",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)323-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Riviere A Pierre",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)324-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "La Malbaie",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)325-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Anne De La Perade",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)326-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Donnacona",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)327-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Stayner",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)328-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Stanislas De Champlain",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)329-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Basile De Portneuf",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)330-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Amqui",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)331-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Thetford Mines",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)332-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Thetford Mines",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)333-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Thetford Mines",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)334-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Thetford Mines",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)335-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Thetford Mines",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)336-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Lac Aux Sables",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)337-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Raymond",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)338-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Thetford Mines",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)339-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Casimir",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)340-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Raymond",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)341-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Thetford Mines",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)342-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Chambord",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)343-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Hebertville Station",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)344-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Hebertville",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)345-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Gedeon",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)346-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Desbiens",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)347-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Delisle",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)348-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Lac Bouchette",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)349-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Metabetchouan",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)350-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Sept Iles",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)351-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "East Broughton",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)352-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Ambroise De Chicoutimi",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)353-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)354-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Roch Des Aulnaies",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)355-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Gaspe",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)356-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Pamphile",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)357-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Pamphile",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)358-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Jean Port Joli",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)359-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Perpetue",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)360-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Gaspe",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)361-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Gaspe",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)362-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Batiscan",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)363-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Andre",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)364-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Carleton",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)365-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Tite",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)366-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Tite",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)368-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Gaspe",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)369-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Marie De Beauce",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)370-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Perce",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)371-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "La Pocatiere",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)372-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "New Richmond",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)373-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Milot",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)374-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Peribonka",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)375-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "New Carlisle",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)376-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Chicoutimi",
                    "operator": "Videotron General Partnership",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)377-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Chute Des Passes",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)378-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Hauterive",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)379-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Bon Accord",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)380-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)381-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Marie De Beauce",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)382-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Martin De Beauce",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)383-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Justine",
                    "operator": "Sogetel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)384-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Stoneham",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)385-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Grande Riviere",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)386-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Marie De Beauce",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)387-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Marie De Beauce",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)388-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Caplan",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)389-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Marie De Beauce",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)390-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Marie De Beauce",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)391-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "New Richmond",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)392-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "New Richmond",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)393-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Grande Vallee",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)394-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Flavien",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)395-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Cloridorme",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)396-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Port Daniel",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)397-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Joseph De Beauce",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)398-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Chandler",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)399-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Pont Rouge",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)400-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Hilarion",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)401-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Agapit",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)402-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Laterriere",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)403-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Marc Des Carrieres",
                    "operator": "Videotron General Partnership",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)404-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Valcartier",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)405-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Fereol",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)406-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Boischatel",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)407-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Loretteville",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)408-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Perce",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)409-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Sept Iles",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)410-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Pont Rouge",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)412-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Jonquiere",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)413-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Antoine De Tilly",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)414-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Val Alain",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)415-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Flavien",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)416-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Rimouski",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)417-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Lambert De Lauzon",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)419-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Tite",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)420-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Marie De Beauce",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)421-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Marie De Beauce",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)422-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Margarets",
                    "operator": "Telebec Ltee.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)423-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Black Lake",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)424-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Leeds",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)425-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Allstream Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)426-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Tring Jonction",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)427-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "East Broughton",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)428-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Ferdinand D Halifax",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)429-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Matane",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)430-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Thetford Mines",
                    "operator": "Ivic Telecom S.e.n.c",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)431-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Iristel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)432-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Pamphile",
                    "operator": "Bell Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)433-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Stayner",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)434-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Fidele",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)435-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Baie St Paul",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)436-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Baie St Paul",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)437-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Chicoutimi",
                    "operator": "Telecommunications Xittel Inc",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)438-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Ile Aux Coudres",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)439-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Clermont",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)440-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Videotron General Partnership",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)441-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Catherine",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)442-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Delisle",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)443-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Stratford",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)444-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Sept Iles",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)445-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Hauterive",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)446-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)447-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Montmagny",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)448-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Marie De Beauce",
                    "operator": "Telus Mobility",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)449-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Disraeli",
                    "operator": "Telebec Ltee.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)450-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Alma",
                    "operator": "Videotron General Partnership",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)451-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Prime",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)452-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Irenee",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)453-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Inverness",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)454-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)455-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)456-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)457-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Hilarion",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)458-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Garthby",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)459-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "La Guadeloupe",
                    "operator": "Telebec Ltee.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)461-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Blanc-sablon",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)462-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Donnacona",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)463-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Notre Dame Des Laurentides",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)464-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Odilion Cranbourne",
                    "operator": "Sogetel Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)465-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Rivington",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)466-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Armagh",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)467-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Damien De Bellechasse",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)469-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Placide Mont",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)470-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Inverness",
                    "operator": "Ivic Telecom S.e.n.c",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)471-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Simeon",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)472-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Francois",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)473-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)475-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Bernard De Dorchester",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)476-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Isp Telecom",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)477-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "La Baie",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)478-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Quebec",
                    "operator": "Fibernetics Corporation",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)479-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Frampton",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)480-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Alma",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)481-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Alma",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)482-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Alma",
                    "operator": "Rogers Communications Partnership (wireless)",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)483-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Courcelles",
                    "operator": "La Cie De Telephone De Courcelles Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)484-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Ephrem De Beauce",
                    "operator": "Le Telephone De St-ephrem Inc",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)485-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Catharines Thorold",
                    "operator": "Telebec Ltee.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)486-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Lambton",
                    "operator": "La Compagnie De Telephone De Lambton Inc.",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)487-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Alma",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)488-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Charny",
                    "operator": "Telus Quebec",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)489-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Clermont",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)490-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Chicoutimi",
                    "operator": "Fido Solutions Inc.",
                    "desc": "Wireless"
                },
                {
                    "mask": "+1(418)491-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Chambord",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)492-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Pascal",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)493-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Andre",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)494-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Ville Degelis",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)495-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Alexandre",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)496-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Nicolas",
                    "operator": "Videotron General Partnership",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)497-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Catharines Thorold",
                    "operator": "Bell Canada",
                    "desc": "Landline"
                },
                {
                    "mask": "+1(418)498-##-##",
                    "cc": "CA",
                    "cd": "Canada",
                    "province": "QC",
                    "city": "Saint Ph