let ChatItem = function (data) { //console.log("ChatItem()"); console.log(data);

    this.type = data.type;

    this.id = data.id;
    this.name = data.nombre;
    this.pic = data.pic;
    this.estatus = data.estatus;

    this.unread = data.unread;
    this.lastupdate = Chat.time();
    this.firstmessage = [];
    this.lastmessage = []; //

    this.html = null;

    this.createHtml();
    this.evalEstatus();
}

ChatItem.prototype.createHtml = function () {

    let chat_string = '' +
    '<div class="chatbox-menu-info chat-nospace">' +
        '<div class="chatbox-menu-name">' + this.name + '<br><i class="chatbox-menu-lastmessage"></i></div>' +
    '</div>' +
    '<div class="chatbox-menu-status offline">&bull;</div>';

    chat_string = '<li class="me-chat-item-message" data-id="' + this.id + '" data-type="' +this.type+ '">' + chat_string + '</li>';
    this.html = $.parseHTML(chat_string);
}

ChatItem.prototype.getLastMessageText = function () { //console.log("ChatItem.getLastMessageText"); console.log(this.lastmessage);
    if (this.lastmessage && this.lastmessage.message) { console.log("YES")
        return Chat.msgHtml(this.lastmessage.message);
    }
    else {
        return '';
    }
}

// checa mensajes sin leer
ChatItem.prototype.evalOpened = function () { //console.log("ChatItem.evalOpened()");
    let item = vChat.getItem(this.id, 'o');
    if (item) {
        item.update();
    }
}

ChatItem.prototype.setOnline = function () { console.log("ChatItem.setOnline()");
    this.estatus = 1;
    $(this.html).find('.chatbox-menu-status').removeClass('offline away').addClass('online');

    let chat = Chat.getChat(this.id);
    if (chat) { chat.setOnline(); }
}

ChatItem.prototype.setOffline = function () { //console.log("ChatItem.setOffline");
    this.estatus = 0;
    $(this.html).find('.chatbox-menu-status').removeClass('online away').addClass('offline');

    let chat = Chat.getChat(this.id);
    if (chat) { chat.setOffline(); }
}

ChatItem.prototype.setAway = function () { console.log("ChatItem.setAway");
    this.estatus = 2;
    $(this.html).find('.chatbox-menu-status').removeClass('online offline').addClass('away');

    let chat = Chat.getChat(this.id);
    if (chat) { chat.setAway(); }
}

// checa estatus online/offline
ChatItem.prototype.evalEstatus = function () { //console.log("ChatItem.evalEstatus()");
    if (this.estatus == 2) { console.log("AWAY");
        this.setAway();
    }
    else if (this.estatus == 1) { console.log("ONLINE");
        this.setOnline();
    }
    else {
        this.setOffline();
    }
}