let NW = require('nw.gui');
let app = NW;
let win = app.Window.get();
//win.showDevTools()

document.onkeydown = function (pressed) {
    //Check CTRL + F5 keys and hard refresh the page
    if ( pressed.ctrlKey === true && pressed.keyCode === 116 ) {
        pressed.preventDefault();
        win.reloadDev();
        return false;
    //Check Shift + F5 keys and refresh ignoring cache
    } else if ( pressed.shiftKey === true && pressed.keyCode === 116 ) {
        pressed.preventDefault();
        win.reloadIgnoringCache();
        return false;
    //Check F5 key and soft refresh
    } else if ( pressed.keyCode === 116 ) {
        pressed.preventDefault();
        win.reload();
        return false;
    //Check F12 or Ctrl+Shift+I and display Webkit Dev Tools
    } else if ( pressed.keyCode === 123 || pressed.ctrlKey === true && pressed.shiftKey === true && pressed.keyCode === 73 ) {
        pressed.preventDefault();
        win.showDevTools();
        return false;
    }
};




/*
$(function() {
    let printer = require("printer");

    let code = barcode('2344723133873', 'EAN13');

    let printData = pos_commands.TXT_ALIGN_RT.concat("Bancas AyC".toBytes()).concat([pos_commands.CTL_LF]);
    printData = printData.concat(pos_commands.TXT_ALIGN_RT).concat("La que siempre paga".toBytes()).concat([pos_commands.CTL_LF]);
    printData = printData.concat(code);
    printData = printData.concat([0x01B, 0x64, 13, 0x1d, 0x56, 0x00]);

    //let printData = " Ack. Y297026163 \n\r Pos ID: 2020030072 \n\r \x1b\x45\x01 YANTRA GROUP-NV \n\r \x1d\x68\50 \x1d\x6b\x02 123456789012 \x0a \x1d\x56\x00";

    printer.printDirect({
        data: new Buffer(printData)
        , printer:'POS58 10.0.0.6'
        , type: 'RAW'
        , success:function(jobID){
            console.log("sent to printer with ID: "+jobID);
        }
        , error:function(err){console.log(err);}
    });
    
 
});
*/

function barcode(code, type, width, height, position, font){

    let buffer = pos_commands.BARCODE_WIDTH.concat(pos_commands.BARCODE_HEIGHT).concat(pos_commands.BARCODE_FONT_A).concat(pos_commands.BARCODE_TXT_BLW).concat(pos_commands.BARCODE_EAN13).concat(code.toBytes());

    return buffer;
};